/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.commandline;

import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;

public final class MinhashOptionCreator {
    public static final String NUM_HASH_FUNCTIONS = "numHashFunctions";
    public static final String KEY_GROUPS = "keyGroups";
    public static final String HASH_TYPE = "hashType";
    public static final String MIN_CLUSTER_SIZE = "minClusterSize";
    public static final String MIN_VECTOR_SIZE = "minVectorSize";
    public static final String NUM_REDUCERS = "numReducers";
    public static final String DEBUG_OUTPUT = "debugOutput";

    private MinhashOptionCreator() {
    }

    public static DefaultOptionBuilder debugOutputOption() {
        return new DefaultOptionBuilder().withLongName(DEBUG_OUTPUT).withShortName("debug").withDescription("Output the whole vectors for debugging");
    }

    public static DefaultOptionBuilder numReducersOption() {
        return new DefaultOptionBuilder().withLongName(NUM_REDUCERS).withRequired(false).withShortName("r").withArgument(new ArgumentBuilder().withName(NUM_REDUCERS).withDefault((Object)"2").withMinimum(1).withMaximum(1).create()).withDescription("The number of reduce tasks. Defaults to 2");
    }

    public static DefaultOptionBuilder minClusterSizeOption() {
        return new DefaultOptionBuilder().withLongName(MIN_CLUSTER_SIZE).withRequired(false).withArgument(new ArgumentBuilder().withName(MIN_CLUSTER_SIZE).withDefault((Object)"10").withMinimum(1).withMaximum(1).create()).withDescription("Minimum points inside a cluster").withShortName("mcs");
    }

    public static DefaultOptionBuilder hashTypeOption() {
        return new DefaultOptionBuilder().withLongName(HASH_TYPE).withRequired(false).withArgument(new ArgumentBuilder().withName(HASH_TYPE).withDefault((Object)"murmur").withMinimum(1).withMaximum(1).create()).withDescription("Type of hash function to use. Available types: (linear, polynomial, murmur) ").withShortName("ht");
    }

    public static DefaultOptionBuilder minVectorSizeOption() {
        return new DefaultOptionBuilder().withLongName(MIN_VECTOR_SIZE).withRequired(false).withArgument(new ArgumentBuilder().withName(MIN_VECTOR_SIZE).withDefault((Object)"5").withMinimum(1).withMaximum(1).create()).withDescription("Minimum size of vector to be hashed").withShortName("mvs");
    }

    public static DefaultOptionBuilder numHashFunctionsOption() {
        return new DefaultOptionBuilder().withLongName(NUM_HASH_FUNCTIONS).withRequired(false).withArgument(new ArgumentBuilder().withName(NUM_HASH_FUNCTIONS).withDefault((Object)"10").withMinimum(1).withMaximum(1).create()).withDescription("Number of hash functions to be used").withShortName("nh");
    }

    public static DefaultOptionBuilder keyGroupsOption() {
        return new DefaultOptionBuilder().withLongName(KEY_GROUPS).withRequired(false).withArgument(new ArgumentBuilder().withName(KEY_GROUPS).withDefault((Object)"2").withMinimum(1).withMaximum(1).create()).withDescription("Number of key groups to be used").withShortName("kg");
    }
}

