/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.distance;

import java.util.Collection;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.parameters.Parameter;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.Vector;

public class CosineDistanceMeasure
implements DistanceMeasure {
    @Override
    public void configure(Configuration job) {
    }

    @Override
    public Collection<Parameter<?>> getParameters() {
        return Collections.emptyList();
    }

    @Override
    public void createParameters(String prefix, Configuration jobConf) {
    }

    public static double distance(double[] p1, double[] p2) {
        double dotProduct = 0.0;
        double lengthSquaredp1 = 0.0;
        double lengthSquaredp2 = 0.0;
        for (int i = 0; i < p1.length; ++i) {
            lengthSquaredp1 += p1[i] * p1[i];
            lengthSquaredp2 += p2[i] * p2[i];
            dotProduct += p1[i] * p2[i];
        }
        double denominator = Math.sqrt(lengthSquaredp1) * Math.sqrt(lengthSquaredp2);
        if (denominator < dotProduct) {
            denominator = dotProduct;
        }
        if (denominator == 0.0 && dotProduct == 0.0) {
            return 1.0;
        }
        return 1.0 - dotProduct / denominator;
    }

    @Override
    public double distance(Vector v1, Vector v2) {
        if (v1.size() != v2.size()) {
            throw new CardinalityException(v1.size(), v2.size());
        }
        double lengthSquaredv1 = v1.getLengthSquared();
        double lengthSquaredv2 = v2.getLengthSquared();
        double dotProduct = v2.dot(v1);
        double denominator = Math.sqrt(lengthSquaredv1) * Math.sqrt(lengthSquaredv2);
        if (denominator < dotProduct) {
            denominator = dotProduct;
        }
        if (denominator == 0.0 && dotProduct == 0.0) {
            return 1.0;
        }
        return 1.0 - dotProduct / denominator;
    }

    @Override
    public double distance(double centroidLengthSquare, Vector centroid, Vector v) {
        double lengthSquaredv = v.getLengthSquared();
        double dotProduct = v.dot(centroid);
        double denominator = Math.sqrt(centroidLengthSquare) * Math.sqrt(lengthSquaredv);
        if (denominator < dotProduct) {
            denominator = dotProduct;
        }
        if (denominator == 0.0 && dotProduct == 0.0) {
            return 1.0;
        }
        return 1.0 - dotProduct / denominator;
    }
}

