/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online.eval;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.PatternFilenameFilter;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import net.myrrix.common.LangUtils;
import net.myrrix.common.collection.FastByIDMap;
import net.myrrix.common.io.IOUtils;
import net.myrrix.common.iterator.FileLineIterable;
import net.myrrix.common.math.SimpleVectorMath;
import net.myrrix.online.ServerRecommender;
import net.myrrix.online.eval.EvaluationResult;
import net.myrrix.online.eval.EvaluationResultImpl;
import net.myrrix.online.generation.Generation;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.util.FastMath;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.recommender.GenericRecommendedItem;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReconstructionEvaluator {
    private static final Logger log = LoggerFactory.getLogger(ReconstructionEvaluator.class);
    private static final Splitter COMMA_TAB_SPLIT = Splitter.on(CharMatcher.anyOf(",\t")).omitEmptyStrings();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EvaluationResult evaluate(File originalDataDir) throws TasteException, IOException, InterruptedException {
        EvaluationResultImpl evaluationResultImpl;
        Preconditions.checkArgument(originalDataDir.exists() && originalDataDir.isDirectory(), "%s is not a directory", originalDataDir);
        File tempDir = Files.createTempDir();
        ServerRecommender recommender = null;
        try {
            Multimap<Long, RecommendedItem> data;
            try {
                data = ReconstructionEvaluator.readAndCopyDataFiles(originalDataDir, tempDir);
            }
            catch (IOException ioe) {
                throw new TasteException(ioe);
            }
            recommender = new ServerRecommender(tempDir);
            recommender.await();
            Generation generation = recommender.getGenerationManager().getCurrentGeneration();
            FastByIDMap<float[]> X = generation.getX();
            FastByIDMap<float[]> Y = generation.getY();
            Mean averageError = new Mean();
            for (Map.Entry<Long, RecommendedItem> entry : data.entries()) {
                long userID = entry.getKey();
                long itemID = entry.getValue().getItemID();
                double value = SimpleVectorMath.dot(X.get(userID), Y.get(itemID));
                averageError.increment(FastMath.max(0.0, 1.0 - value));
            }
            evaluationResultImpl = new EvaluationResultImpl(averageError.getResult());
        }
        catch (Throwable throwable) {
            Closeables.close(recommender, true);
            IOUtils.deleteRecursively(tempDir);
            throw throwable;
        }
        Closeables.close(recommender, true);
        IOUtils.deleteRecursively(tempDir);
        return evaluationResultImpl;
    }

    private static Multimap<Long, RecommendedItem> readAndCopyDataFiles(File dataDir, File tempDir) throws IOException {
        ArrayListMultimap<Long, RecommendedItem> data = ArrayListMultimap.create();
        for (File dataFile : dataDir.listFiles(new PatternFilenameFilter(".+\\.csv(\\.(zip|gz))?"))) {
            log.info("Reading {}", (Object)dataFile);
            int count = 0;
            for (CharSequence line : new FileLineIterable(dataFile)) {
                Iterator<String> parts = COMMA_TAB_SPLIT.split(line).iterator();
                long userID = Long.parseLong(parts.next());
                long itemID = Long.parseLong(parts.next());
                if (parts.hasNext()) {
                    String token = parts.next().trim();
                    if (!token.isEmpty()) {
                        data.put(userID, new GenericRecommendedItem(itemID, LangUtils.parseFloat(token)));
                    }
                } else {
                    data.put(userID, new GenericRecommendedItem(itemID, 1.0f));
                }
                if (++count % 1000000 != 0) continue;
                log.info("Finished {} lines", (Object)count);
            }
            Files.copy(dataFile, new File(tempDir, dataFile.getName()));
        }
        return data;
    }

    public static void main(String[] args) throws Exception {
        ReconstructionEvaluator eval = new ReconstructionEvaluator();
        EvaluationResult result = eval.evaluate(new File(args[0]));
        log.info(result.toString());
    }
}

