/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.common;

import org.apache.mahout.cf.taste.impl.common.FullRunningAverage;
import org.apache.mahout.cf.taste.impl.common.InvertedRunningAverageAndStdDev;
import org.apache.mahout.cf.taste.impl.common.RunningAverageAndStdDev;

public final class FullRunningAverageAndStdDev
extends FullRunningAverage
implements RunningAverageAndStdDev {
    private double stdDev;
    private double mk;
    private double sk;

    public FullRunningAverageAndStdDev() {
        this.mk = 0.0;
        this.sk = 0.0;
        this.recomputeStdDev();
    }

    public FullRunningAverageAndStdDev(int count, double average, double mk, double sk) {
        super(count, average);
        this.mk = mk;
        this.sk = sk;
        this.recomputeStdDev();
    }

    public double getMk() {
        return this.mk;
    }

    public double getSk() {
        return this.sk;
    }

    @Override
    public synchronized double getStandardDeviation() {
        return this.stdDev;
    }

    @Override
    public synchronized void addDatum(double datum) {
        super.addDatum(datum);
        int count = this.getCount();
        if (count == 1) {
            this.mk = datum;
            this.sk = 0.0;
        } else {
            double oldmk = this.mk;
            double diff = datum - oldmk;
            this.mk += diff / (double)count;
            this.sk += diff * (datum - this.mk);
        }
        this.recomputeStdDev();
    }

    @Override
    public synchronized void removeDatum(double datum) {
        int oldCount = this.getCount();
        super.removeDatum(datum);
        double oldmk = this.mk;
        this.mk = ((double)oldCount * oldmk - datum) / (double)(oldCount - 1);
        this.sk -= (datum - this.mk) * (datum - oldmk);
        this.recomputeStdDev();
    }

    @Override
    public void changeDatum(double delta) {
        throw new UnsupportedOperationException();
    }

    private synchronized void recomputeStdDev() {
        int count = this.getCount();
        this.stdDev = count > 1 ? Math.sqrt(this.sk / (double)(count - 1)) : Double.NaN;
    }

    @Override
    public RunningAverageAndStdDev inverse() {
        return new InvertedRunningAverageAndStdDev(this);
    }

    @Override
    public synchronized String toString() {
        return String.valueOf(String.valueOf(this.getAverage()) + ',' + this.stdDev);
    }
}

