/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.iterator;

import com.google.common.base.Function;
import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.mahout.common.Pair;

public class StringRecordIterator
extends ForwardingIterator<Pair<List<String>, Long>> {
    private static final Long ONE = 1L;
    private final Pattern splitter;
    private final Iterator<Pair<List<String>, Long>> delegate;

    public StringRecordIterator(Iterable<String> stringIterator, String pattern) {
        this.splitter = Pattern.compile(pattern);
        this.delegate = Iterators.transform(stringIterator.iterator(), new Function<String, Pair<List<String>, Long>>(){

            @Override
            public Pair<List<String>, Long> apply(String from) {
                String[] items = StringRecordIterator.this.splitter.split(from);
                return new Pair<List<String>, Long>(Arrays.asList(items), ONE);
            }
        });
    }

    @Override
    protected Iterator<Pair<List<String>, Long>> delegate() {
        return this.delegate;
    }
}

