/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common.collection;

import java.io.Serializable;

public final class BitSet
implements Serializable,
Cloneable {
    private final long[] bits;

    public BitSet(int numBits) {
        int numLongs = numBits >>> 6;
        if ((numBits & 0x3F) != 0) {
            ++numLongs;
        }
        this.bits = new long[numLongs];
    }

    private BitSet(long[] bits) {
        this.bits = bits;
    }

    public boolean get(int index) {
        return (this.bits[index >>> 6] & 1L << (index & 0x3F)) != 0L;
    }

    public void set(int index) {
        int n = index >>> 6;
        this.bits[n] = this.bits[n] | 1L << (index & 0x3F);
    }

    public void set(int from, int to) {
        for (int i = from; i < to; ++i) {
            this.set(i);
        }
    }

    public void clear(int index) {
        int n = index >>> 6;
        this.bits[n] = this.bits[n] & (1L << (index & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void clear() {
        int length = this.bits.length;
        for (int i = 0; i < length; ++i) {
            this.bits[i] = 0L;
        }
    }

    public int size() {
        return this.bits.length << 6;
    }

    public int cardinality() {
        int sum = 0;
        for (long l : this.bits) {
            sum += Long.bitCount(l);
        }
        return sum;
    }

    public int nextSetBit(int index) {
        int offset;
        int offsetInLong = index & 0x3F;
        long mask = (1L << offsetInLong) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        for (offset = index >>> 6; offset < this.bits.length && (this.bits[offset] & mask) == 0L; ++offset) {
            mask = -1L;
        }
        if (offset == this.bits.length) {
            return -1;
        }
        return (offset << 6) + Long.numberOfTrailingZeros(this.bits[offset] & mask);
    }

    public BitSet clone() {
        return new BitSet(this.bits);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(64 * this.bits.length);
        for (long l : this.bits) {
            for (int j = 0; j < 64; ++j) {
                result.append((l & 1L << j) == 0L ? (char)'0' : '1');
            }
            result.append(' ');
        }
        return result.toString();
    }
}

