/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.common.jdbc;

import com.google.common.base.Preconditions;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.mahout.cf.taste.common.TasteException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJDBCComponent {
    private static final Logger log = LoggerFactory.getLogger(AbstractJDBCComponent.class);
    private static final int DEFAULT_FETCH_SIZE = 1000;
    protected static final String DEFAULT_DATASOURCE_NAME = "jdbc/taste";

    protected static void checkNotNullAndLog(String argName, Object value) {
        Preconditions.checkArgument(value != null && !value.toString().isEmpty(), argName + " is null or empty");
        log.debug("{}: {}", (Object)argName, value);
    }

    protected static void checkNotNullAndLog(String argName, Object[] values) {
        Preconditions.checkArgument(values != null && values.length != 0, argName + " is null or zero-length");
        for (Object value : values) {
            AbstractJDBCComponent.checkNotNullAndLog(argName, value);
        }
    }

    public static DataSource lookupDataSource(String dataSourceName) throws TasteException {
        InitialContext context = null;
        try {
            context = new InitialContext();
            DataSource dataSource = (DataSource)context.lookup("java:comp/env/" + dataSourceName);
            return dataSource;
        }
        catch (NamingException ne) {
            throw new TasteException(ne);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException ne) {
                    log.warn("Error while closing Context; continuing...", ne);
                }
            }
        }
    }

    protected int getFetchSize() {
        return 1000;
    }
}

