/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;

final class ByRescoreComparator
implements Comparator<RecommendedItem>,
Serializable {
    private final IDRescorer rescorer;

    ByRescoreComparator(IDRescorer rescorer) {
        this.rescorer = rescorer;
    }

    @Override
    public int compare(RecommendedItem o1, RecommendedItem o2) {
        double rescored2;
        double rescored1;
        if (this.rescorer == null) {
            rescored1 = o1.getValue();
            rescored2 = o2.getValue();
        } else {
            rescored1 = this.rescorer.rescore(o1.getItemID(), o1.getValue());
            rescored2 = this.rescorer.rescore(o2.getItemID(), o2.getValue());
        }
        if (rescored1 < rescored2) {
            return 1;
        }
        if (rescored1 > rescored2) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return "ByRescoreComparator[rescorer:" + this.rescorer + ']';
    }
}

