/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.distance;

import java.util.Iterator;
import org.apache.mahout.common.distance.WeightedDistanceMeasure;
import org.apache.mahout.math.Vector;

public class WeightedEuclideanDistanceMeasure
extends WeightedDistanceMeasure {
    @Override
    public double distance(Vector p1, Vector p2) {
        double result = 0.0;
        Vector res = p2.minus(p1);
        Vector theWeights = this.getWeights();
        if (theWeights == null) {
            Iterator iter = res.iterateNonZero();
            while (iter.hasNext()) {
                Vector.Element elt = (Vector.Element)iter.next();
                result += elt.get() * elt.get();
            }
        } else {
            Iterator iter = res.iterateNonZero();
            while (iter.hasNext()) {
                Vector.Element elt = (Vector.Element)iter.next();
                result += elt.get() * elt.get() * theWeights.get(elt.index());
            }
        }
        return Math.sqrt(result);
    }

    @Override
    public double distance(double centroidLengthSquare, Vector centroid, Vector v) {
        return this.distance(centroid, v);
    }
}

