% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cen_signtest.R
\name{cen_signtest}
\alias{cen_signtest}
\title{Sign test for censored data}
\usage{
cen_signtest(xd, xc, yd, yc, alternative = "two.sided", printstat = TRUE)
}
\arguments{
\item{xd}{The first column of data values plus detection limits}

\item{xc}{The column of censoring indicators, where 1 (or \code{TRUE}) indicates a detection limit in the xd column, and 0 (or \code{FALSE}) indicates a detected value in xd.}

\item{yd}{The second column of data values plus detection limits.}

\item{yc}{The column of censoring indicators, where 1 (or \code{TRUE}) indicates a detection limit in the \code{yd} column, and 0 (or \code{FALSE}) indicates a detected value in \code{yd}.}

\item{alternative}{The usual notation for the alternate hypothesis.  Default is \verb{“two.sided”}.  Options are \verb{“greater”} or \verb{“less”}.}

\item{printstat}{Logical \code{TRUE}/\code{FALSE} option of whether to print the resulting statistics in the console window, or not.  Default is \code{TRUE.}}
}
\value{
Returns the number of \code{xd} and \code{yd} values greater than, less than and tied. Corrected and uncorrected \code{p-value} for ties also displayed.
}
\description{
Performs a nonparametric sign test of whether the median difference between two columns of paired censored data equals 0. Uses the Fong adjustment for pairs of equal values.
}
\examples{

data(atrazine)

cen_signtest(atrazine$June,atrazine$JuneCen,atrazine$Sept,atrazine$SeptCen)
}
\references{
Fong, D.Y.T., Kwan, C.W., Lam, K.F., Lam, K.S.L., 2003. Use of the Sign Test for the Median in the Presence of Ties. The American Statistician 57, 237–240.

Helsel, D.R., 2011. Statistics for censored environmental data using Minitab and R, 2nd ed. John Wiley & Sons, USA, N.J.
#'
}
