% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpMissMDA_PCA_MCA_FMAD_A.R
\name{PipeOpmissMDA_PCA_MCA_FMAD_A}
\alias{PipeOpmissMDA_PCA_MCA_FMAD_A}
\alias{PipeOpMissMDA_PCA_MCA_FMAD_A}
\title{PipeOpmissMDA_PCA_MCA_FMAD_A}
\description{
Implements PCA, MCA, FMAD methods as mlr3 pipeline in approach A, more about methods \code{\link{missMDA_FMAD_MCA_PCA}} and \code{\link{missMDA.reuse}}
}
\section{Input and Output Channels}{

Input and output channels are inherited from \code{\link{PipeOpImpute}}.
}

\section{Parameters}{

The parameters include inherited from [`PipeOpImpute`], as well as: \cr
\itemize{
\item \code{id} :: \code{character(1)}\cr
Identifier of resulting object, default \code{"imput_missMDA_MCA_PCA_FMAD"}.
\item \code{optimize_ncp} :: \code{logical(1)}\cr
If TRUE, parameter \emph{number of dimensions}, used to predict the missing values, will be optimized. If FALSE, by default ncp=2 is used, default \code{TRUE}.
\item \code{set_ncp} :: \code{integer(1)}\cr
integer >0. Number of dimensions used by algortims. Used only if optimize_ncp = Flase, default \code{2}.
\item \code{ncp.max} :: \code{integer(1)}\cr
Number corresponding to the maximum number of components to test when optimize_ncp=TRUE, default \code{5}.
\item \code{random.seed} :: \code{integer(1)}\cr
Integer, by default random.seed = NULL implies that missing values are initially imputed by the mean of each variable. Other values leads to a random initialization, default \code{NULL}.
\item \code{maxiter} :: \code{integer(1)}\cr
Maximal number of iteration in algorithm, default \code{998}.
\item \code{coeff.ridge} :: \code{double(1)}\cr
Value used in \emph{Regularized} method, default \code{1}.
\item \code{threshold} :: \code{double(1)}\cr
Threshold for convergence, default \code{1e-6}.
\item \code{method} :: \code{character(1)}\cr
Method used in imputation algorithm, default \code{'Regularized'}.
\item \code{out_fill} :: \code{character(1)}\cr
Output log file location. If file already exists log message will be added. If NULL no log will be produced, default \code{NULL}.
}
}

\examples{
\donttest{

 # Using debug learner for example purpose


  graph <- PipeOpMissMDA_PCA_MCA_FMAD_A$new() \%>>\% LearnerClassifDebug$new()
  graph_learner <- GraphLearner$new(graph)

  # Task with NA
  set.seed(1)
  resample(tsk("pima"), graph_learner, rsmp("cv", folds = 3))
}
}
\section{Super classes}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{\link[mlr3pipelines:PipeOpImpute]{mlr3pipelines::PipeOpImpute}} -> \code{missMDA_MCA_PCA_FMAD_imputation_A}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-missMDA_MCA_PCA_FMAD_imputation_A-new}{\code{PipeOpMissMDA_PCA_MCA_FMAD_A$new()}}
\item \href{#method-missMDA_MCA_PCA_FMAD_imputation_A-clone}{\code{PipeOpMissMDA_PCA_MCA_FMAD_A$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="help"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-help'><code>mlr3pipelines::PipeOp$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-predict'><code>mlr3pipelines::PipeOp$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-print'><code>mlr3pipelines::PipeOp$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-train'><code>mlr3pipelines::PipeOp$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-missMDA_MCA_PCA_FMAD_imputation_A-new"></a>}}
\if{latex}{\out{\hypertarget{method-missMDA_MCA_PCA_FMAD_imputation_A-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpMissMDA_PCA_MCA_FMAD_A$new(
  id = "impute_missMDA_MCA_PCA_FMAD_A",
  optimize_ncp = TRUE,
  set_ncp = 2,
  ncp.max = 5,
  random.seed = NULL,
  maxiter = 998,
  coeff.ridge = 1,
  threshold = 1e-06,
  method = "Regularized",
  out_file = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-missMDA_MCA_PCA_FMAD_imputation_A-clone"></a>}}
\if{latex}{\out{\hypertarget{method-missMDA_MCA_PCA_FMAD_imputation_A-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpMissMDA_PCA_MCA_FMAD_A$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
