% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{futures_price_forecast}
\alias{futures_price_forecast}
\title{Forecast the futures prices of an N-factor model}
\usage{
futures_price_forecast(
  x_0,
  parameters,
  t = 0,
  futures_TTM = 1:10,
  percentiles = NULL
)
}
\arguments{
\item{x_0}{Initial values of the state vector.}

\item{parameters}{A named vector of parameter values of a specified N-factor model. Function \code{NFCP_parameters} is recommended.}

\item{t}{a numeric specifying the time point at which to forecast futures prices}

\item{futures_TTM}{a vector specifying the time to maturity of futures contracts to value.}

\item{percentiles}{Optional. A vector of percentiles to include probabilistic forecasting intervals.}
}
\value{
\code{futures_price_forecast} returns a vector of expected Futures prices under a given N-factor model with specified time to maturities at time \mjeqn{t}{t}.  When \code{percentiles} are specified, the function returns a matrix with the corresponding confidence bands in each column of the matrix.
}
\description{
Analytically forecast future expected Futures prices under the risk-neutral version of a specified N-factor model.
}
\details{
\loadmathjax
Under the assumption or risk-neutrality, futures prices are equal to the expected future spot price. Additionally, under deterministic interest rates, forward prices are equal to futures prices. Let \mjeqn{F_{T,t}}{F[T,t]}
denote the market price of a futures contract at time \mjeqn{t}{t} with time \mjeqn{T}{T} until maturity. let * denote the risk-neutral expectation and variance of futures prices.
The following equations assume that the first factor follows a Brownian Motion.

\mjdeqn{E^*[ln(F_{T,t})] =\sum_{i=1}^Ne^{-\kappa_iT}x_{i}(0) + \mu^*t +  A(T-t)}{E^*[ln(F[T,t])] = sum_{i=1}^N (e^(-kappa[i] T) x[i,0] + mu * t + A(T-t))}

Where:
\mjdeqn{A(T-t) = \mu^*(T-t)-\sum_{i=1}^N - \frac{1-e^{-\kappa_i (T-t)}\lambda_i}{\kappa_i}+\frac{1}{2}(\sigma_1^2(T-t) + \sum_{i.j\neq 1} \sigma_i \sigma_j \rho_{i,j} \frac{1-e^{-(\kappa_i+\kappa_j)(T-t)}}{\kappa_i+\kappa_j})}{
A(T-t) = mu^* (T-t) - sum_{i=1}^N ( - (1 - e^(-kappa[i] (T-t))lambda[i]) / kappa[i]) + 1/2 sigma[1]^2 (T-t) + sum_{i.j != 1} sigma[i] sigma[j] rho[i,j] (1 - e^(-(kappa[i] + kappa[j])(T-t))) / (kappa[i] + kappa[j])}
The variance is given by:
\mjdeqn{Var^*[ln(F_{T,t})]= \sigma_1^2t + \sum_{i.j\neq1} e^{-(\kappa_i + \kappa_j)(T-t)}\sigma_i\sigma_j\rho_{i,j}\frac{1-e^{-(\kappa_i+\kappa_j)t}}{\kappa_i+\kappa_j}}{
Var^*[ln(F[T,t])] = sigma[1]^2 * t + sum_{i.j != 1} e^(-(kappa[i] + kappa[j])(T-t)) sigma[i] sigma[j] rho[i,j] (1 - e^(-(kappa[i] + kappa[j])t))/(kappa[i] + kappa[j])}
}
\examples{

# Forecast futures prices of the Schwartz and Smith (2000) two-factor oil model:
## Step 1 - Run the Kalman filter for the two-factor oil model:
SS_2F_filtered <- NFCP_Kalman_filter(parameter_values = SS_oil$two_factor,
                                    parameter_names = names(SS_oil$two_factor),
                                    log_futures = log(SS_oil$stitched_futures),
                                    dt = SS_oil$dt,
                                    futures_TTM = SS_oil$stitched_TTM,
                                    verbose = TRUE)

## Step 2 - Probabilistic forecast of the risk-neutral two-factor
## stochastic differential equation (SDE):
futures_price_forecast(x_0 = SS_2F_filtered$x_t,
                      parameters = SS_oil$two_factor,
                      t = 0,
                      futures_TTM = seq(0,9,1/12),
                      percentiles = c(0.1, 0.9))
}
\references{
Schwartz, E. S., and J. E. Smith, (2000). Short-Term Variations and Long-Term Dynamics in Commodity Prices. \emph{Manage. Sci.}, 46, 893-911.

Cortazar, G., and L. Naranjo, (2006). An N-factor Gaussian model of oil futures prices. \emph{Journal of Futures Markets: Futures, Options, and Other Derivative Products}, 26(3), 243-268.
}
