% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi_correction.R
\name{chi_correct}
\alias{chi_correct}
\title{Performs chi-square based variation reduction}
\usage{
chi_correct(nipt_sample, nipt_control_group, chi_cutoff = 3.5,
  include_XY = F)
}
\arguments{
\item{nipt_sample}{The NIPTSample object that is the focus of the analysis}

\item{nipt_control_group}{The NIPTControlGroup object used in the analysis}

\item{chi_cutoff}{The Z-score cutoff. If a bin has a Z-score above this threshold,
it will be corrected}

\item{include_XY}{Also apply correction to X and Y chromosomes?}
}
\value{
Named list of length 2. The corrected nipt_sample is in index 1 and the 
corrected control group in index 2
to extract the corrected sample use \code{$sample} or \code{[[1]]}. 
To extract the control group from the list use
\code{$control_group} or \code{[[2]]}
}
\description{
Performs chi-square based variation reduction
}
\details{
The chi-squared based variation reduction identifies overdispersed bins within 
the control group and corrects these bins in both the sample of interest and the control group. 
The function takes in a `NIPTSample` and a `NIPTControlGroup` object, both to be corrected. 
For every corresponding bin in the control group a chi-squared score is calculated and this 
total score is converted to a normal distribution. Corresponding bins with a normalized score 
above _chi_cutoff_ (default 3.5) are corrected by dividing the number of reads by the total 
chi-squared score divided by degrees of freedom
}
\examples{
\dontrun{
##Apply chi-squared based variation reduction method
chi_corrected_data <- chicorrect(nipt_sample = gc_LOESS_corrected_sample, 
                                 nipt_control_group = subset_loess_corrected_control_group)
##Extract sample and control group
loess_chi_corrected_sample <- chi_corrected_data$sample
subset_loess_chi_corrected_control_group <- chi_corrected_data$control_group
}

}

