% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlm_mosaicfield.R
\name{nlm_mosaicfield}
\alias{nlm_mosaicfield}
\title{nlm_mosaicfield}
\usage{
nlm_mosaicfield(nCol, nRow, resolution = 1, n = 20, mosaic_mean = 0.5,
  mosaic_sd = 0.5, collect = FALSE, infinit = FALSE, rescale = TRUE)
}
\arguments{
\item{nCol}{[\code{numerical(1)}]\cr
Number of columns for the raster.}

\item{nRow}{[\code{numerical(1)}]\cr
Number of rows for the raster.}

\item{resolution}{[\code{numerical(1)}]\cr
Resolution of the raster.}

\item{n}{[\code{numerical(1)}]\cr
Number of steps that the mosaic random field algorithm is run}

\item{mosaic_mean}{[\code{numerical(1)}]\cr
Mean value of the mosaic displacement distribution}

\item{mosaic_sd}{[\code{numerical(1)}]\cr
Standard deviation of the mosaic displacement distribution}

\item{collect}{[\code{logical(1)}]\cr
return RasterBrick of all steps 1:n}

\item{infinit}{[\code{logical(1)}]\cr
return raster of the random mosaic field algorithm with infinite steps}

\item{rescale}{[\code{logical(1)}]\cr
If \code{TRUE} (default), the values are rescaled between 0-1.}
}
\value{
RasterLayer or List with RasterLayer(s) and/or RasterBrick
}
\description{
Create a mosaic random field neutral landscape model.
}
\examples{
nlm_mosaicfield(nCol = 200,
                nRow = 200,
                n = NA,
                infinit = TRUE,
                collect = FALSE)

}
\references{
Schwab, Dimitri, Martin Schlather, and Jürgen Potthoff. "A general class of
mosaic random fields." arXiv preprint arXiv:1709.01441 (2017). \cr
Baddeley, Adrian, Ege Rubak, and Rolf Turner. Spatial point patterns:
methodology and applications with R. CRC Press, 2015.
}
