% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlm_randomelement.R
\name{nlm_randomelement}
\alias{nlm_randomelement}
\title{nlm_randomelement}
\usage{
nlm_randomelement(nCol, nRow, resolution = 1, n, rescale = TRUE)
}
\arguments{
\item{nCol}{[\code{numerical(1)}]\cr
Number of columns for the raster.}

\item{nRow}{[\code{numerical(1)}]\cr
Number of rows for the raster.}

\item{resolution}{[\code{numerical(1)}]\cr
Resolution of the raster.}

\item{n}{[\code{numerical(1)}]\cr
The number of elements randomly selected to form the basis of
nearest-neighbour clusters.}

\item{rescale}{[\code{logical(1)}]\cr
If \code{TRUE} (default), the values are rescaled between 0-1.}
}
\value{
Raster layer with values between 0 and 1
}
\description{
Simulates a random rectangular cluster neutral landscape model.
}
\details{
The algorithm selects \code{n} random cell of the matrix and assigns them a
uniformly distributed random value. The cells are then converted to a point
pattern and interpolated by voronoi tessellation.
}
\examples{
nlm_randomelement(nCol = 10, nRow = 10, n = 10)

}
\references{
Etherington TR, Holland EP, O’Sullivan D. 2015. NLMpy: A python software
package for the creation of neutral landscape models within a general
numerical framework. \emph{Methods in Ecology and Evolution} 6:164 – 168.
}
