% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlm_gaussianfield.R
\name{nlm_gaussianfield}
\alias{nlm_gaussianfield}
\title{nlm_gaussianfield}
\usage{
nlm_gaussianfield(ncol, nrow, resolution = 1, autocorr_range = 10,
  mag_var = 5, nug = 0.2, mean = 0.5, user_seed = NULL,
  rescale = TRUE)
}
\arguments{
\item{ncol}{[\code{numerical(1)}]\cr
Number of columns for the raster.}

\item{nrow}{[\code{numerical(1)}]\cr
Number of rows for the raster.}

\item{resolution}{[\code{numerical(1)}]\cr
Resolution of the raster.}

\item{autocorr_range}{[\code{numerical(1)}]\cr
Maximal distance of spatial autocorrelation}

\item{mag_var}{[\code{numerical(1)}]\cr
Magnitude of variation in the field}

\item{nug}{[\code{numerical(1)}]\cr
Small-scale variations in the field.}

\item{mean}{[\code{numerical(1)}]\cr
Mean value over the field.}

\item{user_seed}{[\code{numerical(1)}]\cr
Set Seed for simulation}

\item{rescale}{[\code{numeric(1)}]\cr
If \code{TRUE} (default), the values are rescaled between 0-1.}
}
\value{
RasterLayer
}
\description{
Simulates a spatially correlated random fields (Gaussian random
fields) model.
}
\examples{
# simulate random gaussian field
gaussian_field <- nlm_gaussianfield(ncol = 90, nrow = 90,
                                    autocorr_range = 10,
                                    mag_var = 3,
                                    nug = 0.01)

\dontrun{
# visualize the NLM
util_plot(gaussian_field)
}

}
