% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlm_randomcluster.R
\name{nlm_randomcluster}
\alias{nlm_randomcluster}
\title{nlm_randomcluster}
\usage{
nlm_randomcluster(ncol, nrow, resolution = 1, p, ai = c(0.5, 0.5),
  neighbourhood = 4, rescale = TRUE)
}
\arguments{
\item{ncol}{[\code{integer(1)}]\cr
Number of columns forming the raster.}

\item{nrow}{[\code{integer(1)}]\cr
Number of rows forming the raster.}

\item{resolution}{[\code{numerical(1)}]\cr
Resolution of the raster.}

\item{p}{[\code{numerical(1)}]\cr
Defines the proportion of elements randomly selected to form
clusters.}

\item{ai}{Vector with the cluster type distribution (percentages of occupancy).
This directly controls the number of types via the given length.}

\item{neighbourhood}{[\code{numerical(1)}]\cr
Clusters are defined using a set of neighbourhood structures,
 4 (Rook's or von Neumann neighbourhood) (default), 8 (Queen's or Moore neighbourhood).}

\item{rescale}{[\code{logical(1)}]\cr
If \code{TRUE} (default), the values are rescaled between 0-1.}
}
\value{
Raster with random values ranging from 0-1.
}
\description{
Simulates a random cluster nearest-neighbour neutral landscape.
}
\details{
This is a direct implementation of steps A - D of the modified random clusters algorithm
by Saura & Martínez-Millán (2000), which creates naturalistic patchy patterns.
}
\examples{
# simulate random clustering
random_cluster <- nlm_randomcluster(ncol = 30, nrow = 30,
                                     p = 0.4,
                                     ai = c(0.25, 0.25, 0.5))
\dontrun{
# visualize the NLM
landscapetools::util_plot(random_cluster)
}

}
\references{
Saura, S. & Martínez-Millán, J. (2000) Landscape patterns simulation with a
modified random clusters method. \emph{Landscape Ecology}, 15, 661 – 678.
}
