% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Qnetplot.R
\name{Qnetplot}
\alias{Qnetplot}
\title{Q-Q plot for network meta-analysis (Q-Q netplot).}
\usage{
Qnetplot(data)
}
\arguments{
\item{data}{object of class NMAoutlier.measures (mandatory).}
}
\description{
This function generates the Q-Q plot for network meta-analyisis model.
}
\details{
Plot of Q-squared Mahalanobis distance for each study included in the network meta-analysis.
Vertical axis provides the Q-squared Mahalanobis distance for each i study included in the network meta-analysis.
Horizontal axis provides Q estimated quantiles (theoretical quantiles from the normal distribution).
A reference line is fitted from the cartesian points of the two measures.
The Q-Q plot can visualize studies that are away from the reference line (potiential outliers).

Q-Q plot for network meta-analysis has been introduced by Petropoulou (2020).
}
\examples{
library("netmeta")
data(smokingcessation)

p1 <- pairwise(list(treat1, treat2, treat3),
  list(event1, event2, event3), list(n1, n2, n3),
  data = smokingcessation, sm = "OR")

# Outlier and influential detection measures
measures <- NMAoutlier.measures(p1)

# Mahalanobis distance values for each study in the network
measures$Mah

# Q-Q netplot for the network of smoking cessation dataset
Qnetplot(measures)

}
\references{
Petropoulou M (2020):
Exploring methodological challenges in network meta-analysis models and
developing methodology for outlier detection.
\emph{PhD dissertation}
}
\author{
Maria Petropoulou <maria.petropoulou@uniklinik-freiburg.de>
}
\keyword{hplot}
