% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic-ctl-manipulation.R
\name{delete_dollar}
\alias{delete_dollar}
\title{Delete a NONMEM subroutine from control file contents}
\usage{
delete_dollar(m, dollar)
}
\arguments{
\item{m}{An nm object.}

\item{dollar}{Character. Name of subroutine.}
}
\value{
An nm object with modified \code{ctl_contents} field.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))

m1 \%>\% dollar("TABLE")
m1 <- m1 \%>\% delete_dollar("TABLE")
m1 \%>\% dollar("TABLE")  ## missing

}
