% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_nm.R
\name{run_nm}
\alias{run_nm}
\alias{run_nm_batch}
\title{Run NONMEM jobs}
\usage{
run_nm(
  m,
  ignore.stdout = TRUE,
  ignore.stderr = TRUE,
  quiet = getOption("quiet_run"),
  intern = getOption("intern"),
  force = FALSE,
  cache_ignore_cmd = FALSE,
  cache_ignore_ctl = FALSE,
  cache_ignore_data = FALSE
)

run_nm_batch(m, threads = 10, ...)
}
\arguments{
\item{m}{An nm object.}

\item{ignore.stdout}{Logical (default=\code{TRUE}). Parameter passed to \code{system_nm()}.}

\item{ignore.stderr}{Logical (default=\code{TRUE}). Parameter passed to \code{system_nm()}.}

\item{quiet}{Logical (default=\code{FALSE}). Should \code{system_nm()} output be piped to
screen?}

\item{intern}{Logical. \code{intern} argument to be passed to \code{system_nm()}.}

\item{force}{Logical (default = \code{FALSE}).  Force run even results unchanged.}

\item{cache_ignore_cmd}{Logical (default = \code{FALSE}). Should check \code{cmd} field
with cache?}

\item{cache_ignore_ctl}{Logical (default = \code{FALSE}). Should check control file
contents with cache?}

\item{cache_ignore_data}{Logical (default = \code{FALSE}). Should check dataset with
cache?}

\item{threads}{Numeric.  Number of threads to run concurrently.}

\item{...}{Additional arguments passed to \code{run_nm()}.}
}
\value{
\code{m} with \code{job_info} fields populated.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Run nm objects.  Uses \code{system_nm()} to submit the \code{cmd()} value of object.
}
\details{
In grid environment it is recommended to run \code{\link[=nm_tran]{nm_tran()}} via the
RStudio 'Addin' prior to executing this code.

By default, when highlighting code and evaluating it via an RStudio app,
\code{run_nm()} will not execute and will just return the \code{nm} object.

For vector \code{nm} objects of length more than 1, all runs will be launched at
the same time.  This could overwhelm resources if not in a grid
environment.  In this case see \code{\link[=run_nm_batch]{run_nm_batch()}} for batched execution of a
vector valued \code{nm} object.

\code{run_nm_batch} is a variant of \code{run_nm()} containing a \code{threads} argument that will submit \code{\link[=run_nm]{run_nm()}}'s in
batches and wait for them to complete. If you need all the runs to complete ensure you use a
\code{\link[=wait_finish]{wait_finish()}} statement afterwards as R console will only be
blocked for until the last batch has been submitted which will be before
all runs have completed
}
\examples{
## requires NONMEM to be installed
\dontrun{
m1 <- new_nm(
  run_id = "m1",
  based_on = "staging/Models/ADVAN2.mod",
  data_path = "DerivedData/data.csv"
) \%>\%
  cmd("execute {ctl_name} -dir={run_dir}") \%>\%
  fill_input() \%>\%
  run_nm()
}
}
\seealso{
\code{\link[=nm_tran]{nm_tran()}}
}
