; Used for comparing single versus parallel computing for FOCE method.
$PROB RUN# Example 1 (from samp5l)
$INPUT C SET ID JID TIME  DV=CONC AMT=DOSE RATE EVID MDV CMT CLX V1X QX V2X SDIX SDSX
$DATA example1.csv IGNORE=C

$SUBROUTINES ADVAN3 TRANS4

$PK
MU_1=THETA(1)
MU_2=THETA(2)
MU_3=THETA(3)
MU_4=THETA(4)
CL=DEXP(MU_1+ETA(1))
V1=DEXP(MU_2+ETA(2))
Q=DEXP(MU_3+ETA(3))
V2=DEXP(MU_4+ETA(4))
S1=V1

LCL=LOG(CL)
LV1=LOG(V1)
LQ=LOG(Q)
LV2=LOG(V2)
RECNO=NDREC

$ERROR
IPRED=F
If(COMACT==1) PREDU=IPRED
Y = IPRED + IPRED*EPS(1)

; Initial values of THETA
$THETA 2 2 2 2
;INITIAL values of OMEGA
$OMEGA BLOCK(4)
0.15   ;[P]
0.01  ;[F]
0.15   ;[P]
0.01  ;[F]
0.01  ;[F]
0.15   ;[P]
0.01  ;[F]
0.01  ;[F]
0.01  ;[F]
0.15   ;[P]
;Initial value of SIGMA
$SIGMA 
(0.6 )   ;[P]

$EST METHOD=1 INTERACTION NSIG=3 PRINT=1 NOABORT  MAXEVAL=9999 SIGL=10 FAST
$COV MATRIX=R PRINT=E UNCONDITIONAL 
$TABLE ID RECNO TIME IPRED PREDU PRED VARCALC=3 NOAPPEND NOPRINT FILE=predu.tab
