% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stack_intermediate.R
\name{NNS.stack.intermediate}
\alias{NNS.stack.intermediate}
\title{NNS.stack.intermediate (INTERNAL CALL FOR \link{NNS.stack})}
\usage{
NNS.stack.intermediate(IVs.train, DV.train, IVs.test = NULL, DV.test = NULL,
  CV.size = 0.2, weight = "MSE", text = F, precision = NULL)
}
\arguments{
\item{IVs.train}{Training set of independent variables.}

\item{DV.train}{Training set of dependent variable.}

\item{IVs.test}{Test set of independent variables.}

\item{DV.test}{Test set of dependent variable.}

\item{CV.size}{Sets the cross-validation size if \code{DV.test=NULL}.  Defaults to 0.2 or a 20 percent random sampling of the training set.}

\item{weight}{Set \code{weight="MSE"} for optimum parameters and weighting based on each base model's \code{"MSE"}.  \code{weight="Feautures"} uses a weighting based on the number of features present, whereby logistic \link{NNS.reg} and \link{NNS.Feature.prob} receive higher weights for more independent variables.  Defaults to \code{"MSE"}.}

\item{text}{If performing a text classification, set \code{text=TRUE}.  Defaults to FALSE.}

\item{precision}{Increases speed of computation at the expense of precision.  2 settings offered: \code{"LOW"} ,and \code{"HIGH"}.  \code{"HIGH"} is the limit condition of every observation as a regression point.  \code{precision=NULL} (Defualt) compares both precision types and then returns the best model parameters.}
}
\value{
Returns a vector of fitted values for the dependent variable test set for all models.  \code{"NNS.reg.n.best"} returns the optimum \code{"n.best"} paramater for the \link{NNS.reg} multivariate regression.  \code{"NNS.logistic.order"} returns the optimum \code{"order"} from the \link{NNS.reg} logistic regression.  \code{"reg"} returns \link{NNS.reg} output, \code{"logistic"} returns \link{NNS.reg} logistic regression output, \code{"Feature.prob"} returns \link{NNS.Feature.prob} output, and \code{"stack"} returns the output of the stacked model.  \code{"CV.test"} returns the random cross-validation dependent variable used and \code{"MSE"} returns the MSE from cross-validation.
}
\description{
Called by \code{NNS.stack} for precision testing in cross-validation.
}
\author{
Fred Viole, OVVO Financial Systems
}

