% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebp.R
\name{ebp}
\alias{ebp}
\title{EBP for proportion under generalized linear mixed model}
\usage{
ebp(
  formula,
  vardir,
  Ni,
  ni,
  method = "REML",
  maxit = 100,
  precision = 1e-04,
  data
)
}
\arguments{
\item{formula}{an object of class list of formula, describe the model to be fitted}

\item{vardir}{a vector of sampling variances of direct estimators for each small area}

\item{Ni}{a vector of population size for each small area}

\item{ni}{a vector of sample size for each small area}

\item{method}{type of fitting method, default is "REML" method}

\item{maxit}{number of iterations allowed in the algorithm. Default is 100 iterations}

\item{precision}{convergence tolerance limit for the Fisher-scoring algorithm. Default value is 1e-04}

\item{data}{a data frame comprising the variables named in formula and vardir}
}
\value{
The function returns a list with the following objects:
\describe{
  \item{ebp}{a vector with the values of the estimators for each small area}
  \item{mse}{a vector of the mean squared error estimates for each small area}
  \item{sample}{a matrix consist of area code, ebp, mse, standard error (SE) and coefficient of variation (CV)}
  \item{fit}{a list containing the following objects:}
  \itemize{
    \item estcoef : a data frame with the estimated model coefficients in the first column (beta),
        their asymptotic standard errors in the second column (std.error), the t statistics in
        the third column (tvalue) and the p-values of the significance of each coefficient in
        last column (pvalue)
    \item refvar : estimated random effects variance
    \item randomeffect : a data frame with the values of the random effect estimators
    \item loglike : value of the loglikelihood
    \item deviance : value of the deviance
    \item loglike1 : value of the restricted loglikelihood
  }
 }
}
\description{
This function gives the ebp and the estimate of mean squared error (mse) for proportion
   based on a generalized linear mixed model.
}
\examples{
# Load data set
data(headcount)
# Fit generalized linear mixed model using HCR data
result <- ebp(y~x1, var, N, n,"REML",100,1e-04, headcount)
result
}
