% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PP.test.R
\name{PP.test}
\alias{PP.test}
\title{Random shift test of independence in a bivariate point process}
\usage{
PP.test(X, Y, N.shifts = 999, radius, correction, verbose = FALSE)
}
\arguments{
\item{X}{first point pattern dataset (object of class \code{ppp})}

\item{Y}{second point pattern dataset (object of class \code{ppp})}

\item{N.shifts}{integer, how many random shifts should be performed in the random shift test}

\item{radius}{positive real number determining the radius of the disk on which the shift vectors are uniformly distributed}

\item{correction}{which correction should be applied in the random shift test (possible choices are "torus" and "variance")}

\item{verbose}{logical value indicating whether auxiliary information should be printed and auxiliary figures plotted during the computation}
}
\value{
The p-value of the random shift test of independence between a pair of point processes.
}
\description{
Nonparametric test of independence between a pair of point processes based on random shifts.
Either the torus correction or the variance correction can be used (note that the
variance correction is not yet implemented in this package but the corresponding source
codes can be obtained from the authors upon request).
}
\details{
The test statistic is the expectation of the cross nearest-neighbor distance, see the paper
Mrkvička et al. (2021). The test statistic based on the cross K-function is
not provided here due to its poor performance in the simulation experiments
described in the paper.

The two observed point patterns to be tested should be supplied using the
arguments \code{X} and \code{Y}. The shift vectors are generated from the
uniform distribution on the disk with radius given by the argument \code{radius}
and centered in the origin. The argument \code{verbose} determines if
auxiliary information and plots should be provided.
}
\examples{

library(spatstat)

set.seed(123)

X <- rpoispp(150)
Y <- rpoispp(150)

out <- PP.test(X=X, Y=Y, N.shifts=499, radius=0.5, correction="torus", verbose=TRUE)
out

}
\references{
T. Mrkvička, J. Dvořák, J.A. González, J. Mateu (2021): Revisiting the random shift approach for testing in spatial statistics. Spatial Statistics 42, 100430.
}
