% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nail_qda.R
\name{nail_qda}
\alias{nail_qda}
\title{Interpret QDA data}
\usage{
nail_qda(
  dataset,
  formul,
  firstvar,
  lastvar = length(colnames(dataset)),
  introduction = "",
  request = NULL,
  model = "llama3",
  isolate.groups = FALSE,
  drop.negative = FALSE,
  proba = 0.05,
  generate = TRUE
)
}
\arguments{
\item{dataset}{a data frame made up of at least two categorical variables (product, panelist) and a set of quantitative variables (sensory attributes).}

\item{formul}{the analyis of variance model to be evaluated for each sensory attribute.}

\item{firstvar}{the index of the first sensory attribute.}

\item{lastvar}{the index of the last sensory attribute.}

\item{introduction}{the introduction for the LLM prompt.}

\item{request}{the request for the LLM prompt.}

\item{model}{the model name ('llama3' by default).}

\item{isolate.groups}{a boolean that indicates whether to give the LLM a single prompt, or one prompt per product.}

\item{drop.negative}{a boolean that indicates whether to drop negative v.test values for interpretation (keeping only positive v.tests).}

\item{proba}{the significance threshold considered to characterize the products (by default 0.05).}

\item{generate}{a boolean that indicates whether to generate the LLM response. If FALSE, the function only returns the prompt.}
}
\value{
A data frame, or a list of data frames, containing the LLM's prompt and response (if generate = TRUE).
}
\description{
Generate an LLM response to analyze QDA data.
}
\details{
This function directly sends a prompt to an LLM. Therefore, to get a consistent answer, we highly recommend to customize the parameters introduction and request and add all relevant information on your data for the LLM. We also recommend renaming the columns with clear, unshortened and unambiguous names.

Additionally, if isolate.groups = TRUE, you will need an introduction and a request that take into account the fact that only one group is analyzed at a time.
}
\examples{
\dontrun{
# Processing time is often longer than ten seconds
# because the function uses a large language model.

### Example 1: QDA data on chocolates  ###
library(NaileR)
library(SensoMineR)
data(chocolates)

intro_sensochoc <- "Six chocolates were measured according
to sensory attributes by a trained panel.
I will give you the results from this study.
You will have to identify what sets these chocolates apart."
intro_sensochoc <- gsub('\n', ' ', intro_sensochoc) |>
stringr::str_squish()

req_sensochoc <- "Please explain what makes each chocolate distinct
and provide a sensory profile of each chocolate."
req_sensochoc <- gsub('\n', ' ', req_sensochoc) |>
stringr::str_squish()

res_nail_qda <- nail_qda(sensochoc,
                         formul="~Product+Panelist",
                         firstvar = 5,
                         introduction = intro_sensochoc,
                         request = NULL,
                         model = 'llama3',
                         isolate.groups = FALSE,
                         drop.negative = FALSE,
                         proba = 0.05,
                         generate = TRUE)

cat(res_nail_qda$response)
}
}
