% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\name{subHeadings}
\alias{subHeadings}
\alias{subHeadings,numeric,numeric-method}
\alias{subHeadings,agentMatrix,numeric-method}
\alias{subHeadings,numeric,agentMatrix-method}
\alias{subHeadings,agentMatrix,agentMatrix-method}
\title{Subtract \code{headings}}
\usage{
subHeadings(angle1, angle2, range360 = FALSE)

\S4method{subHeadings}{numeric,numeric}(angle1, angle2, range360 = FALSE)

\S4method{subHeadings}{agentMatrix,numeric}(angle1, angle2, range360 = FALSE)

\S4method{subHeadings}{numeric,agentMatrix}(angle1, angle2, range360 = FALSE)

\S4method{subHeadings}{agentMatrix,agentMatrix}(angle1, angle2, range360 = FALSE)
}
\arguments{
\item{angle1}{\code{AgentMatrix} object representing the moving \code{agents}, or

              Numeric. Vector of angles.}

\item{angle2}{\code{AgentMatrix} object representing the moving \code{agents}, or

              Numeric. Vector of angles.}

\item{range360}{Logical. If \code{range360 = TRUE}, returned values are
between 0 and 360 degrees;
if \code{range360 = FALSE}, returned values are between
-180 and 180 degrees.
Default is \code{range360 = FALSE}.}
}
\value{
Numeric. Vector of the smallest angles in degrees
        by which \code{angle1} could be rotated to produce \code{angle2}
        (i.e., the target heading).
}
\description{
Compute the difference between \code{headings}.
}
\details{
This function does the opposite as the one in NetLogo where
         \code{angle1} is the target heading.

        \code{angle1} and \code{angle2} must be of the same length or if different,
        one of them must be of length 1.

         Positive values mean clockwise rotations, negative value mean
         counterclockwise rotations.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 9, minPycor = 0, maxPycor = 9)
t1 <- createOTurtles(n = 10, world = w1)
subHeadings(angle1 = t1, angle2 = 0)


}
\references{
Wilensky, U. 1999. NetLogo. http://ccl.northwestern.edu/netlogo/.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#subtract-headings}
}
\author{
Sarah Bauduin
}
