% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/world-functions.R
\name{raster2world}
\alias{raster2world}
\alias{raster2world,ANY-method}
\title{Convert a \verb{Raster*} object into a \code{worldMatrix} or \code{worldArray} object}
\usage{
raster2world(raster)

\S4method{raster2world}{ANY}(raster)
}
\arguments{
\item{raster}{\code{RasterLayer} or \code{RasterStack} object.}
}
\value{
\code{WorldMatrix} or \code{worldArray} object depending on the input \code{raster}.
\code{Patches} value are retained from the \code{raster}.
}
\description{
Convert a \code{RasterLayer} object into a \code{worldMatrix} object or a \code{RasterStack} object
into a \code{worldArray} object.
}
\details{
See \code{help("worldMatrix-class")} or \code{help("worldArray-class")}
for more details on the classes.

\if{html}{\out{<div class="sourceCode">}}\preformatted{     The number of rows and columns, as well as the cell values of the `raster`
     are kept the same. However, to match the coordinates system and resolution of a
     `worldMatrix` or `worldArray`, the grid is shifted by a 1/2 cell to have
     round coordinate values at the center of the patches and patch size is equal to (1,1).
     The bottom left corner cell coordinates of the `worldMatrix` or `worldArray`
     will be (pxcor = 0, pycor = 0).
}\if{html}{\out{</div>}}
}
\examples{
if (requireNamespace("raster")) {
  r1 <- raster::raster(raster::extent(c(0, 10, 0, 10)), nrows = 10, ncols = 10)
  r1[] <- runif(100)
  w1 <- raster2world(r1)
  terra::plot(r1)
  terra::plot(w1)
}

}
\author{
Sarah Bauduin
}
