% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nd_csd.R
\name{nd.csd}
\alias{nd.csd}
\title{\eqn{L_2} Distance of Continuous Spectral Densities}
\usage{
nd.csd(A, out.dist = TRUE, bandwidth = 1)
}
\arguments{
\item{A}{a list of length \eqn{N} containing \eqn{(M\times M)} adjacency matrices.}

\item{out.dist}{a logical; \code{TRUE} for computed distance matrix as a \code{dist} object.}

\item{bandwidth}{common bandwidth of positive real number.}
}
\value{
a named list containing \describe{
\item{D}{an \eqn{(N\times N)} matrix or \code{dist} object containing pairwise distance measures.}
\item{spectra}{an \eqn{(N\times M-1)} matrix where each row is top-\eqn{M-1} vibrational spectra.}
}
}
\description{
The method employs spectral density of eigenvalues from
Laplacian in that for each, we have corresponding
spectral density \eqn{\rho(w)} as a sum of
narrow Lorentz distributions with \code{bandwidth} parameter.
Since it involves integration of a function over the
non-compact domain, it may blow up to infinity and the code
automatically aborts the process.
}
\examples{
\dontrun{
## generate two types of adjacency matrices of size (3-by-3)
set.seed(45)
rbin1 = rbinom(9,1,0.8); mat1 = matrix(rbin1,nrow=3)
rbin2 = rbinom(9,1,0.2); mat2 = matrix(rbin2,nrow=3)

mattype1 = ceiling((mat1+t(mat1))/2); diag(mattype1)=0;
mattype2 = ceiling((mat2+t(mat2))/2); diag(mattype2)=0;

A = list()
for (i in 1:3){A[[i]]=mattype1} # first 3 are type-1
for (i in 4:6){A[[i]]=mattype2} # next  3 are type-2

## Compute Distance Matrix and Visualize
output = nd.csd(A, out.dist=FALSE, bandwidth=1.0)
image(output$D, main="two group case")
}

}
\references{
\insertRef{ipsen_evolutionary_2002}{NetworkDistance}
}
