% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cascade.R
\name{as.data.frame.cascade}
\alias{as.data.frame.cascade}
\title{Convert a cascade object to a data frame}
\usage{
\method{as.data.frame}{cascade}(x, row.names = NULL, optional = FALSE, ...)
}
\arguments{
\item{x}{Cascade object to convert.}

\item{row.names}{NULL or a character vector giving the row names for the data 
frame. Missing values are not allowed.}

\item{optional}{logical. If TRUE, setting row names and converting column 
names (to syntactic names: see make.names) is optional. (Not supported)}

\item{...}{Additional arguments passed to \code{\link{data.frame}}.}
}
\value{
A data frame with three columns. Containing 1) The names of 
    the nodes (\code{"node_name"}) that experience an event in each cascade, 
    2) the event time (\code{"event_time"}) of the corresponding node, 
    3) the cascade identifier \code{"cascade_id"}.
}
\description{
Generates a data frame containing the cascade information in the cascade object.
}
\examples{

data(cascades)
as.data.frame(cascades)

}
