% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{pediatric_glioma_tbl_df}
\alias{pediatric_glioma_tbl_df}
\title{Pediatric High-Grade Glioma Clinical Dataset}
\format{
A tibble with 57 observations and 22 variables:
\describe{
  \item{Age}{Numeric: Patient age in years}
  \item{Gender}{Character: Patient gender}
  \item{Headache}{Character: Headache presence/characteristics}
  \item{Epilepsy}{Character: Epilepsy status}
  \item{Hemparesis}{Character: Hemiparesis presence}
  \item{increaseICT}{Character: Increased intracranial pressure indicators}
  \item{Pathology}{Character: Tumor pathology classification}
  \item{Pathology_Grade}{Numeric: WHO tumor grade (III-IV)}
  \item{Thalamic_extension}{Character: Thalamic involvement}
  \item{Bil_extension}{Character: Bilateral extension}
  \item{Post_extension}{Character: Posterior fossa extension}
  \item{BrainStem_extension}{Character: Brainstem involvement}
  \item{MultiFocality}{Character: Multifocal tumor presence}
  \item{Midlineshift}{Character: Midline shift presence}
  \item{Edema}{Character: Peritumoral edema characteristics}
  \item{Approx_Tumor_Vol}{Numeric: Estimated tumor volume (cm³)}
  \item{ExtentofSurgicalresection}{Character: Surgical resection extent}
  \item{Shunt}{Character: Ventricular shunt presence}
  \item{ResidualsizeonMRI}{Character: Post-surgical residual tumor}
  \item{Neurostate}{Character: Neurological status}
  \item{PSBeforeRT}{Numeric: Performance status pre-radiotherapy}
  \item{Died}{Character: Mortality outcome}
}
}
\source{
Kaggle dataset: Pediatric High-Grade Glioma Dataset.
URL: \url{https://www.kaggle.com/datasets/amraam/pediatric-high-grade-glioma-dataset}
}
\usage{
data(pediatric_glioma_tbl_df)
}
\description{
This dataset, pediatric_glioma_tbl_df, is a tibble containing comprehensive
clinical and tumor characteristics for 57 pediatric patients with high-grade
glioma. The data includes 22 variables covering demographic, symptomatic,
pathological, treatment, and outcome measures.
}
\details{
The dataset name has been kept as 'pediatric_glioma_tbl_df' to avoid confusion
with other datasets in the R ecosystem. This naming convention helps distinguish
this dataset as part of the NeuroDataSets package. The suffix 'tbl_df' indicates
that the dataset is a tibble. The original content has not been modified.
}
