% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modules.R
\name{nlin_causality.test}
\alias{nlin_causality.test}
\title{A non linear Granger causality test}
\usage{
nlin_causality.test(
  ts1,
  ts2,
  lag,
  LayersUniv,
  LayersBiv,
  iters = 50,
  learningRate = 0.01,
  algo = "sgd",
  batch_size = 10,
  bias = TRUE,
  seed = 0,
  activationsUniv = vector(),
  activationsBiv = vector()
)
}
\arguments{
\item{ts1}{Numerical series.}

\item{ts2}{Numerical series.}

\item{lag}{The lag parameter}

\item{LayersUniv}{Integer vector that contains the size of hidden layers of the univariate model. The length of this vector is the number of hidden layers, and the i-th element is the number of neurons in the i-th hidden layer.}

\item{LayersBiv}{Integer vector that contains the size of hidden layers of the bivariate model. The length of this vector is the number of hidden layers, and the i-th element is the number of neurons in the i-th hidden layer.}

\item{iters}{The number of iterations.}

\item{learningRate}{The learning rate to use, O.1 by default, and if Adam algorithm is used, then it is the initial learning rate.}

\item{algo}{String argument, for the optimisation algorithm to use, in choice ["sgd", "adam"]. By default "sgd" (stochastic gradient descent) is used. The algorithm 'adam' is to adapt the learning rate while using "sgd".}

\item{batch_size}{Integer argument for the batch size used in the back-propagation algorithm.}

\item{bias}{Logical argument  for the option of using the bias in the networks.}

\item{seed}{Integer value for the random seed used in the random generation of the weights of the network (a value = 0 will use the clock as random generator seed).}

\item{activationsUniv}{String vector for the activations functions to use (in choice ["sigmoid", "relu", "tanh"]) for the univariate model. The length of this vector is the number of hidden layers plus one (the output layer). By default, the relu activation function is used in hidden layers, and the sigmoid in the last layer.}

\item{activationsBiv}{String vector for the activations functions to use (in choice ["sigmoid", "relu", "tanh"]) for the bivariate model. The length of this vector is the number of hidden layers plus one (the output layer). By default, the relu activation function is used in hidden layers, and the sigmoid in the last layer.}
}
\value{
gci: the Granger causality index.

Ftest:  the statistic of the test.

pvalue: the p-value of the test.

summary ():  shows the test results.
}
\description{
A non linear Granger causality test
}
\details{
A non-linear test of causality using artificial neural networks. Two MLP artificial neural networks are evaluated to perform the test, one using just the target time series (ts1), and the second using both time series. The null hypothesis of this test is that the second time series does not cause the first one.
}
\examples{
library (timeSeries) # to extract time series
library (NlinTS)
data = LPP2005REC
model = nlin_causality.test (data[,1], data[,2], 2, c(2), c(4), 50, 0.01, "sgd", 30, TRUE, 5)
model$summary ()
}
