% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate-pair-links-are-symmetric.R
\name{ValidatePairLinksAreSymmetric}
\alias{ValidatePairLinksAreSymmetric}
\title{Verifies that the pair relationships are symmetric.}
\usage{
ValidatePairLinksAreSymmetric(linksPair)
}
\arguments{
\item{linksPair}{The \link[base:data.frame]{base::data.frame} object that should be symmetric}
}
\value{
Returns \code{TRUE} if symmetric.  Throw an error with \code{\link[base:stop]{base::stop()}} if asymmetric.
}
\description{
For certain analyses, the pairs links (which can be considered a type of
sparse matrix) need to be symmetric. For instance, if there is a row for
Subjects 201 and 202 with \code{R}=0.5, there should be a second row for
Subjects 202 and 201 with \code{R}=0.5.

This validation function is useful to some types of DF methods and some
spatially-inspired methods.
}
\examples{
dsSingleLinks <- data.frame(
  ExtendedID       = c(1, 1, 1, 2),
  SubjectTag_S1    = c(101, 101, 102, 201),
  SubjectTag_S2    = c(102, 103, 103, 202),
  R                = c(.5, .25, .25, .5),
  RelationshipPath = rep("Gen2Siblings", 4)
)
dsSingleOutcomes <- data.frame(
  SubjectTag = c(101, 102, 103, 201, 202),
  DV1        = c(11, 12, 13, 41, 42),
  DV2        = c(21, 22, 23, 51, 52)
)
dsDouble <- CreatePairLinksDoubleEntered(
  outcomeDataset         = dsSingleOutcomes,
  linksPairDataset       = dsSingleLinks,
  outcomeNames           = c("DV1", "DV2"),
  validateOutcomeDataset = TRUE
)
dsDouble # Show the 8 rows in the double-entered pair links
summary(dsDouble) # Summarize the variables

ValidatePairLinksAreSymmetric(dsDouble) # Should return TRUE.
}
\seealso{
\code{\link[=CreatePairLinksDoubleEntered]{CreatePairLinksDoubleEntered()}}
}
\author{
Will Beasley
}
\keyword{validation}
