% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MvtInvBeta.R
\name{MvtInvBeta}
\alias{MvtInvBeta}
\alias{dmvinvbeta}
\alias{pmvinvbeta}
\alias{qmvinvbeta}
\alias{rmvinvbeta}
\alias{smvinvbeta}
\title{Multivariate Inverted Beta Distribution}
\usage{
dmvinvbeta(x, parm1 = 1, parm2 = rep(1, k), log = FALSE)

pmvinvbeta(
  q,
  parm1 = 1,
  parm2 = rep(1, k),
  algorithm = c("numerical", "MC"),
  nsim = 1e+07
)

qmvinvbeta(
  p,
  parm1 = 1,
  parm2 = rep(1, k),
  interval = c(1e-08, 1e+08),
  algorithm = c("numerical", "MC"),
  nsim = 1e+06
)

rmvinvbeta(n, parm1 = 1, parm2 = rep(1, k))

smvinvbeta(
  q,
  parm1 = 1,
  parm2 = rep(1, k),
  algorithm = c("numerical", "MC"),
  nsim = 1e+07
)
}
\arguments{
\item{x}{vector or matrix of quantiles. If \eqn{x} is a matrix, each row vector constitutes a vector of quantiles for which the density \eqn{f(x)} is calculated (for \eqn{i}-th row \eqn{x_i}, \eqn{f(x_i)} is reported).}

\item{parm1}{a scalar parameter, see parameter \eqn{a} in \strong{Details}.}

\item{parm2}{a vector of parameters, see parameter \eqn{l_i} in \strong{Details}.}

\item{log}{logical; if TRUE, probability densities \eqn{f} are given as \eqn{log(f)}.}

\item{q}{a vector of quantiles.}

\item{algorithm}{method to be used for calculating cumulative probability. Two options are provided as (i) \code{numerical} using adaptive multivariate integral and (ii) \code{MC} using Monte Carlo method. Recommend algorithm \code{numerical} for \eqn{(k <= 4)} dimension and \code{MC} for \eqn{(k > 4)} dimension based on running time consumption. Default option is set as \code{numerical}.}

\item{nsim}{number of simulations used in algorithm \code{MC}.}

\item{p}{a scalar value corresponding to probability.}

\item{interval}{a vector containing the end-points of the interval to be searched. Default value is set as \code{c(1e-8, 1e8)}.}

\item{n}{number of observations.}

\item{k}{dimension of data or number of variates.}
}
\value{
\code{dmvinvbeta} gives the numerical values of the probability density.

\code{pmvinvbeta} gives a list of two items:

\eqn{\quad} \code{value} cumulative probability

\eqn{\quad} \code{error} the estimated relative error by \code{algorithm = "numerical"} or the estimated standard error by \code{algorithm = "MC"}

\code{qmvinvbeta} gives the equicoordinate quantile. \code{NaN} is returned for no solution found in the given interval. The result is seed dependent if Monte Carlo algorithm is chosen  (\code{algorithm = "MC"}).

\code{rmvinvbeta} generates random numbers.

\code{smvinvbeta} gives a list of two items:

\eqn{\quad} \code{value} the value of survial function

\eqn{\quad} \code{error} the estimated relative error by \code{algorithm = "numerical"} or the estimated standard error by \code{algorithm = "MC"}
}
\description{
Calculation of density function, cumulative distribution function, equicoordinate quantile function and survival function, and random numbers generation for multivariate inverted beta distribution with a scalar parameter \code{parm1} and a vector of parameters \code{parm2}.
}
\details{
Multivariate inverted beta distribution is an alternative expression of multivariate F distribution and is a special case of multivariate Lomax distribution (Balakrishnan and Lai, 2009). Its probability density is given as
\deqn{f(x_1, \cdots, x_p) = \frac{\Gamma(\sum_{i=1}^{p} l_i + a) \prod_{i=1}^{p} x_i^{l_i-1}}{\Gamma(a) [\prod_{i=1}^{p} \Gamma(l_i)] (1+\sum_{i=1}^{p} x_i)^{\sum_{i=1}^{p} l_i + a}},}
where \eqn{x_i>0, a>0, l_i>0, i=1,\cdots, p}.

Cumulative distribution function \eqn{F(x_1, \dots, x_k)} is obtained by multiple integral
\deqn{F(x_1, \dots, x_k) = \int_{0}^{x_1} \cdots  \int_{0}^{x_k} f(y_1, \cdots, y_k) dy_k \cdots dy_1.}
This multiple integral is calculated by either adaptive multivariate integration using \code{\link{hcubature}} in package \strong{\link{cubature}} (Narasimhan et al., 2018) or via Monte Carlo method.

Equicoordinate quantile is obtained by solving the following equation for \eqn{q} through the built-in one dimension root finding function \code{\link{uniroot}}:
\deqn{\int_{0}^{q} \cdots \int_{0}^{q} f(x_1, \cdots, x_k) dx_k \cdots dx_1 = p,}
where \eqn{p} is the given cumulative probability.

The survival function \eqn{\bar{F}(x_1, \cdots, x_k)} is obtained either by the following formula related to cumulative distribution function \eqn{F(x_1, \dots, x_k)} (Joe, 1997)
\deqn{\bar{F}(x_1, \cdots, x_k) = 1 + \sum_{S \in \mathcal{S}} (-1)^{|S|} F_S(x_j, j \in S),}
or via Monte Carlo method.

Random numbers \eqn{X_1, \cdots, X_k} from multivariate inverted beta distribution can be generated through parameter substitutions in simulation of generalized multivariate Lomax distribution by letting \eqn{\theta_i = 1, i = 1, \cdots, k}.
}
\examples{
# Calculations for the multivariate inverted beta with parameters:
# a = 7, l1 = 1, l2 = 3
# Vector of quantiles: c(2, 4)

dmvinvbeta(x = c(2, 4), parm1 = 7, parm2 = c(1, 3)) # Density

# Cumulative Probability using adaptive multivariate integral
pmvinvbeta(q = c(2, 4), parm1 = 7, parm2 = c(1, 3))

\donttest{
# Cumulative Probability using Monte Carlo method
pmvinvbeta(q = c(2, 4), parm1 = 7, parm2 = c(1, 3), algorithm = "MC")}

\donttest{
# Equicoordinate quantile of cumulative probability 0.5
qmvinvbeta(p = 0.5, parm1 = 7, parm2 = c(1, 3))}

# Random numbers generation with sample size 100
rmvinvbeta(n = 100, parm1 = 7, parm2 = c(1, 3))

smvinvbeta(q = c(2, 4), parm1 = 7, parm2 = c(1, 3)) # Survival function

}
\references{
Balakrishnan, N. and Lai, C. (2009). \emph{Continuous Bivariate Distributions. 2nd Edition.} New York: Springer.

Joe, H. (1997). \emph{Multivariate Models and Dependence Concepts}. London: Chapman & Hall.

Narasimhan, B.,  Koller, M., Johnson, S. G., Hahn, T., Bouvier, A., Kiêu, K. and Gaure, S. (2018). cubature: Adaptive Multivariate Integration over Hypercubes. R package version 2.0.3.

Nayak, T. K. (1987). Multivariate Lomax Distribution: Properties and Usefulness in Reliability Theory. \emph{Journal of Applied Probability}, Vol. 24, No. 1, 170-177.
}
\seealso{
\code{\link{uniroot}} for one dimensional root (zero) finding.
}
