% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NonProbEst.R
\name{fast_jackknife_variance}
\alias{fast_jackknife_variance}
\title{Calculates Jackknife variance without reweighting}
\usage{
fast_jackknife_variance(sample, weights, estimated_vars, N = NULL)
}
\arguments{
\item{sample}{A data frame containing the sample.}

\item{weights}{A vector containing the pre-calculated weights.}

\item{estimated_vars}{A string vector specifying the variables for which the estimators' variance are to be estimated.}

\item{N}{Integer indicating the population size. Optional.}
}
\value{
A vector containing the resulting variance for each variable.
}
\description{
Calculates the variance of a given estimator by Leave-One-Out Jackknife (Quenouille, 1956) with the original adjusted weights.
}
\details{
The variance estimation is performed by eliminating an individual at each iteration with its corresponding weight and estimating the mean of the corresponding subsample, which is further used in the Jackknife formula as the usual procedure. The calculation of variance estimates through this procedure might take less computation time but also might not take into account the variance of the weighting method.
}
\examples{
covariates = c("education_primaria", "education_secundaria", "education_terciaria")
data_propensities = propensities(sampleNP, sampleP, covariates)
psa_weights = sc_weights(data_propensities$convenience)
fast_jackknife_variance(sampleNP, psa_weights, c("vote_pens"), 50000)
}
\references{
Quenouille, M. H. (1956). \emph{Notes on bias in estimation.} Biometrika, 43(3/4), 353-360.
}
