% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HeatMap.r
\name{HeatMap}
\alias{HeatMap}
\title{Heat map}
\usage{
HeatMap(featuredata, groupdata, saveplot = FALSE, plotname = "heatmap",
  savetype = c("png", "bmp", "jpeg", "tiff", "pdf"), interactiveplot = TRUE,
  saveinteractiveplot = FALSE, colramp = c(75, "magenta", "green"),
  scale = c("row", "column", "none"), dendrogram = c("column", "row",
  "both", "none"), distmethod = "euclidean", aggmethod = "complete",
  margins = c(5, 5), key = TRUE, keysize = 1.5, cexRow = 0.5,
  ColSideColors = NULL, ...)
}
\arguments{
\item{featuredata}{A data frame in the met data format. This should have sample
names in the first column to be read as row names and the metabolomics variables 
in the remaining columns.}

\item{groupdata}{A data frame or a table with optional sample names in the 
first column to be read as row names and group names in the following column.}

\item{saveplot}{A logical indication whether to save the plot produced.}

\item{plotname}{Name of the output file if the file is to be saved.}

\item{savetype}{The required format for the plot to be saved in. Threre is a
choice of \code{"png","bmp","jpeg","tiff","pdf"} type files.}

\item{interactiveplot}{A logical indication whether an interactive plot
is to be shown.}

\item{saveinteractiveplot}{A logical indication whether to save the interactive plot as
an \code{"html"} file.}

\item{colramp}{A vector containing (in order), the desired number of color elements in the panel,
color to use for the lowest, color to use for the highest for the non-interactive plot.}

\item{scale}{A character indicating if the values should be scaled
metabolite-wise ("\code{row}") or group-wise ("\code{column}").}

\item{dendrogram}{A character indicating whether to draw "\code{none}",
"\code{row}", "\code{column}" or "\code{both}" dendrograms for non-interactive plots.}

\item{distmethod}{The distance measure to be used. This must be one of
"\code{euclidean}", "\code{maximum}", "\code{manhattan}", "\code{canberra}",
"\code{binary}" or "\code{minkowski}".}

\item{aggmethod}{The agglomeration method to be used. This should be one of
"\code{ward}", "\code{single}", "\code{complete}", "\code{average}",
"\code{mcquitty}", "\code{median}" or "\code{centroid}".}

\item{margins}{A numeric vector of length 2 containing the margins for group
and metabolite names, respectively.}

\item{key}{A logical indicating whether a colour key must be drawn.}

\item{keysize}{A numeric indicating the size of the key.}

\item{cexRow}{A numeric indicating the size of the metabolite names.}

\item{ColSideColors}{A character vector indicating the colours different
groups.}

\item{...}{Arguments to be passed on to other methods.}
}
\description{
Produces an interactive or a non-interactive heat map of a metabolomics data matrix optionally clustered
according to specified methods
}
\examples{

    data(mixdata)  #unadjusted data
    HeatMap(mixdata$featuredata,mixdata$sampledata[,1], 
             saveplot = FALSE, 
            interactiveplot = TRUE, scale = "row", 
            dendrogram = "none", colramp=c(75,"magenta","green"))

}
\seealso{
\code{\link[graphics]{par}}, \code{heatmap.2}.
}
\author{
Alysha M De Livera, Gavriel Olshansky
}
