% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PcaPlots.R
\name{PcaPlots}
\alias{PcaPlots}
\title{PCA plots}
\usage{
PcaPlots(featuredata, groupdata, saveplot = FALSE,
  saveinteractiveplot = FALSE, plotname = "", savetype = c("png", "bmp",
  "jpeg", "tiff", "pdf"), interactiveonly = FALSE, interactiveplots = TRUE,
  y.axis = 1, x.axis = 2, center = TRUE, scale = TRUE,
  userinput = TRUE, returninteractive = FALSE, main = NULL,
  varplot = FALSE, multiplot = FALSE, n = 3, cols = NULL,
  cex_val = 0.7, ...)
}
\arguments{
\item{featuredata}{featuredata A data frame in the featuredata format. 
 This is a dataframe with metabolites in columns and samples in rows.
Unique sample names should be provided as row names.
See NormalizeMets Vignette for details.}

\item{groupdata}{A data frame or a vector with group names.}

\item{saveplot}{A logical indication whether to save the plot produced.}

\item{saveinteractiveplot}{A logical indication whether to save the interactive plots produced.}

\item{plotname}{Name of the output file if the file is to be saved. This is
the general name for all the graphs and the specific type prefix will be
added automatically.}

\item{savetype}{The required format for the plot to be saved in. Threre is a
choice of \code{"png","bmp","jpeg","tiff","pdf"} type files.}

\item{interactiveonly}{Alogical indicating whether to show interactive 
plots only.}

\item{interactiveplots}{A logical indication whether an interactive plot
is to be shown.}

\item{y.axis}{The principal component to be plotted on the \emph{y}-axis.}

\item{x.axis}{The principal component to be plotted on the \emph{x}-axis.}

\item{center}{A logical indicating whether the variables should be scaled to
have zero mean.}

\item{scale}{A logical indicating whether the variables should be scaled to
have unit variance before the analysis takes place.}

\item{userinput}{A logical indication whether user input should be required to 
show plots progressively. Should be \code{FALSE} when the plots are to be passed
on to other functions or saved as variables for later use.}

\item{returninteractive}{A logical indication whether a list of the interactive plots
should be returned by the function}

\item{main}{Plot title.}

\item{varplot}{A logical indicating whether explained variance should be
plotted.}

\item{multiplot}{If \code{TRUE}, pairs plots of the first \emph{n} principal
components will be plotted.}

\item{n}{The number of principal components to be plotted if
\code{multiplot=TRUE}. The default value is set to 5.}

\item{cols}{A character string with colours to be used.}

\item{cex_val}{A numeric indicating the size of some text elements.}

\item{...}{Arguments to be passed on to other methods.}
}
\description{
Produces PCA plots of the metabolomics data.
}
\examples{

    data(mixdata)
    
    # produce all results
    PcaPlots(mixdata$featuredata,mixdata$sampledata[,3],multiplot = TRUE, 
    varplot = TRUE, interactiveplots = TRUE)
    
    # return a list of the ineractive plots only
    interactive.pca <- PcaPlots(mixdata$featuredata,mixdata$sampledata[,3],
    interativeonly = TRUE, interactiveplots = TRUE,
    userinput = FALSE, returninteractive = TRUE)
    

}
\seealso{
\code{\link[stats]{prcomp}}.
}
\author{
Alysha M De Livera, Gavriel Olshansky
}
