% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ES.R
\name{ES}
\alias{ES}
\title{Expected Shortfall}
\usage{
ES(
  variance,
  alpha = 0.95,
  weights = NULL,
  model = c("normal", "t-student", "both"),
  df = NULL,
  percentage = FALSE
)
}
\arguments{
\item{variance}{It could be either a scalar or a matrix containing the variances and covariances
of the losses. Provide a covariance matrix when analyzing correlated losses or a scalar when
dealing with a single loss.}

\item{alpha}{A numeric value (either a single one or a vector) consisting of the significance level
at which ES has to be computed, it can either be a single numeric value or a vector of numeric values.}

\item{weights}{A vector of weights of size \emph{N} for weighting the variance of losses.
When \code{weights=NULL} variances used to compute ES are the original values supplied to  \code{variance}
with no weighting scheme.}

\item{model}{A character string indicating which distribution is to be used for computing the ES,
the default value is the \code{normal} distribution, the other alternative is \code{t-student}
distribution with \eqn{\upsilon}{\upsilon} degrees of freedom. When \code{model='both'} \code{'normal'}
as well as \code{'t-student'} are used when computing the ES, see examples.}

\item{df}{An integer indicating the degrees of freedom for the t-student distribution when setting
\code{model='t-student'} and \code{model='both'}. \code{df} must be greater than 2.}

\item{percentage}{Logical indicating whether the file names in the VaR table should be presented in percentage or decimal.}
}
\description{
\loadmathjax{}
 Computes the Expected Shortfall of a given amount of loss based on variance-covariance method.
}
\details{
\code{ES} computes the Expected Shortfall (ES) of a certaing amount of loss based upon the following general formulation:

\mjtdeqn{ES_\alpha = \frac{1}{1-\alpha}\int_{\alpha}^{1} VaR_u(X)du = E[X|X > F_{X}^{-1}(\alpha)]}{ES_\alpha = \dfrac{1}{1-\alpha}\int_{\alpha}^{1} VaR_u(X)du = E[X|X > F_{X}^{-1}(\alpha)]}{}

where \mjteqn{\alpha}{\alpha}{} is the significance level, \mjteqn{VaR_u(X)}{VaR_u(X)}{} is the Value-at-Risk of \mjteqn{X.}{X.}{}

\code{ES} for the normal case is based on the following expression:

\mjtdeqn{ES_{\alpha} = \mu + \sigma \frac{\phi(\Phi^{-1}(\alpha))}{1-\alpha}}{ES_{\alpha} = \mu + \sigma \frac{\phi(\Phi^{-1}(\alpha))}{1-\alpha}}{}

Meanwhile, \code{ES} for the t-student distribution takes comes from:

\mjtdeqn{ES_{\alpha}(\tilde{X}) = \frac{g_{\upsilon}(t_{\upsilon}^{-1}(\alpha))}{1-\alpha} \left( \frac{\upsilon+(t_{\upsilon}^{-1}(\alpha))^{2}}{\upsilon - 1} \right)}{ES_{\alpha}(\tilde{X}) = \frac{g_{\upsilon}(t_{\upsilon}^{-1}(\alpha))}{1-\alpha} \left( \frac{\upsilon+(t_{\upsilon}^{-1}(\alpha))^{2}}{\upsilon - 1} \right)}{}
}
\examples{
# Exercise 2.21, page 46 in McNeil et al (2005)
alpha <- c(.90, .95, .975, .99, .995)
(ES(variance=(0.2/sqrt(250))^2, alpha=alpha, model='normal'))*10000
(ES(variance=(0.2/sqrt(250))^2, alpha=alpha, model='t-student', df=4))*10000

# Both type of models at once.
(ES(variance=(0.2/sqrt(250))^2, alpha=alpha, model='both', df=4))*10000

# A vector of losses
variance <- matrix(c(100,150,150,900), 2) # covariance matrix
w <- c(0.5, 0.5)                        # a vector weights
ES(variance=variance, weights=w, alpha=0.95)

}
\references{
Dhaene J., Tsanakas A., Valdez E. and Vanduffel S. (2011). \emph{Optimal Capital Allocation Principles}. The Journal of Risk and Insurance. Vol. 00, No. 0, 1-28.

McNeil, A. J.; Frey, R. & Embrechts, P. \emph{Quantitative risk management: concepts, techniques and tools}. Princeton University Press, 2005.

Urbina, J. (2013) \emph{Quantifying Optimal Capital Allocation Principles based on Risk Measures.} Master Thesis, Universitat Politècnica de Catalunya.

Urbina, J. and Guillén, M. (2014). \emph{An application of capital allocation principles to operational risk and the cost of fraud}. Expert Systems with Applications. 41(16):7023-7031.
}
\author{
Jilber Urbina
}
