\name{draw_elev2D_OCN}
\alias{draw_elev2D_OCN}
\title{Plot 2D map of elevation generated by an OCN}
\usage{
draw_elev2D_OCN(OCN, colPalette = terrain.colors(1000, alpha = 1),
addLegend = TRUE, drawRiver = FALSE, thrADraw = 0.002*OCN$FD$nNodes*OCN$cellsize^2,
riverColor = "#00BFFF", min_lwd = 0.5, max_lwd = 5, args_imagePlot = list())
}
\arguments{
\item{OCN}{A \code{river} object as produced by \code{\link{landscape_OCN}}.}

\item{colPalette}{Color palette used for the plot.}

\item{addLegend}{Logical. If \code{TRUE}, \code{\link{image.plot}} is used to display the legend; as a result, elements (e.g. node coordinates) subsequently plotted of on top of the 2D elevation map might be wrongly positioned.}

\item{drawRiver}{Logical. If \code{TRUE}, draw the OCN on top of the elevation map.}

\item{thrADraw}{Threshold drainage area value used to display the network.}

\item{riverColor}{Color used to display the OCN (only effective if \code{drawRiver = TRUE}). }

\item{min_lwd, max_lwd}{Minimum and maximum values of line width used to display the OCN (actual line width is proportional to the square root of drainage area).}

\item{args_imagePlot}{List of arguments passed to \code{\link{imagePlot}} (or to \code{\link{image}} if \code{addLegend = FALSE}). For example, argument \code{smallplot} can be used to specify the plot coordinates for the legend.}
}
\value{
No output is returned.
}
\description{
Function that plots the 2D elevation map generated by an OCN.
}
\examples{
# 1) draw 2D map of a 20x20 OCN with default settings
draw_elev2D_OCN(landscape_OCN(OCN_20))
}
