% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extra_data.R
\name{extra_data}
\alias{extra_data}
\title{Download Open Case Study Extra Data}
\usage{
extra_data(casestudy, outpath = NULL)
}
\arguments{
\item{casestudy}{character string, name of the case study to pull data from.
The input name should follow the same naming scheme as the repository on GitHub:

ocs-bp-opioid-rural-urban

ocs-bp-RTC-wrangling

ocs-bp-co2-emissions}

\item{outpath}{character string, path to the directory where the downloaded
data folder should be saved to.}
}
\value{
If download is successful, the path to the downloaded data folder is
returned. Otherwise the appropriate error message is returned.
}
\description{
Download the specified case study extra data to use as you wish.
}
\details{
This function downloads the Open Case Study extra data
from GitHub and saves it in a new 'OCS_data/data/extra/' folder in
the specified directory. This makes it so all the extra data
are easily available in a local folder for your use.
}
\examples{
tmp = tempfile()
dir.create(tmp)
extra_data('ocs-bp-opioid-rural-urban', outpath = tmp)

}
