\name{ODB-package}
\alias{ODB-package}
\alias{ODB}
\docType{package}
\title{
  Open Document Databases (.odb) management
}

\description{
  This package provides functions to create, connect, update and query HSQL databases embedded in Open Document Databases (.odb) files, as OpenOffice and LibreOffice do.
}

\details{
  \tabular{ll}{
    Package: \tab ODB\cr
    Type: \tab Package\cr
    Version: \tab 1.0\cr
    Date: \tab 2011-04-22\cr
    License: \tab GPL 3\cr
    LazyLoad: \tab yes\cr
    Depends: \tab methods, DBI, RJDBC, XML\cr
  }
  
  First notice this package is not intented to manage all .odb variations. Currently two distinct types of .odb files can be distinguished : files embedding an HSQL database, and files connecting to a remote database engine such as MySQL. This package is made for the formers, as remote database engines can be queried directly using the DBI package. Functions involving the XML content of the .odb file (\code{\link{odb.comments}} and \code{\link{odb.queries}}) may be operative on such files, but there is no garantee they would be.
  
  You should not consider this package without minimal knowledge of the SQL language, as only the more basic operations have functions not relying on the user to build a valid SQL query (\code{\link{odb.insert}}, \code{\link{odb.tables}}, \code{\link{odb.comments}}, \code{\link{odb.queries}}).
  
  This package is built around the \code{odb} class, which extends \code{DBIConnection}. A set of functions is provided to execute reading (SELECT ...) or writing (INSERT, CREATE, DROP ...) SQL queries through the HSQLDB engine, and a set of convenient tools is also provided for the more common tasks (\code{\link{odb.read}}, \code{\link{odb.write}}, \code{\link{odb.insert}}). A few Open Document specific functions are also provided, allowing modifications on features provided by the .odb file format and not the database itself (\code{\link{odb.comments}} and \code{\link{odb.queries}}).
  
  Effects of all these functions can be achieved manually via the OpenOffice or LibreOffice Base softwares, obviously this package offers a way of making it automaticaly on a wider scale. Both manual and automatic modifications can be done on the same .odb file, but you are strongly recommended to not use the two methods simultaneously. This R package works on a copy of the file made at the \code{\link{odb.open}} call, and this copy will replace the original file at the \code{\link{odb.close}} call, regardless of what happened between the two calls.
  
  Additional tools are also provided, notably \code{\link{odb.export}}, \code{\link{odb.zip}} and \code{\link{isClosed}}.
  
  See the 'examples' section for more details on the package behavior.
}

\author{
  Sylvain Mareschal <maressyl@gmail.com>
}

\examples{

  ## CONNECTION ##
  
  # Creation of a new .odb database
  odb.create("test.odb", overwrite="do")

  # Connection to the file
  ODB <- odb.open("test.odb")
  
  
  ## STRUCTURE ##
  
  # Creation of a new table
  SQL <- "CREATE TABLE fruits (id INTEGER PRIMARY KEY, value VARCHAR(8))"
  odb.write(ODB, SQL)
  
  # Addition of comments on columns
  odb.comments(ODB, "fruits", c("id", "value")) <- c("Fruit rank", "Fruit name")
  
  # Printing of the database structure
  print(odb.tables(ODB))
  
  # Printing of a specific comment
  print(odb.comments(ODB, "fruits", "value"))
  
  
  ## DATA ##
  
  # Insertion of data
  data <- data.frame(id=1:3, value=c("apple", "orange", "pear"))
  odb.insert(ODB, tableName="fruits", data=data, execute=TRUE)
  
  # Reading
  print(odb.read(ODB, "SELECT * FROM fruits WHERE id=2"))
  
  # Saved query
  odb.queries(ODB, "2nd record") <- "SELECT * FROM fruits WHERE id=2"
  print(odb.read(ODB, odb.queries(ODB, "2nd record")))
  
  # SQL export
  odb.export(ODB, "test.sql")
  
  
  ## DISCONNECTION ##
  
  # Is the connection closed ?
  print(isClosed(ODB))
  
  # Save changes in the .odb file
  odb.close(ODB, write=TRUE)
  
  # And now ?
  print(isClosed(ODB))
}
