% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ODT_depth.R
\name{plot_ODT_depth}
\alias{plot_ODT_depth}
\title{plot oblique decision tree depth}
\usage{
plot_ODT_depth(
  formula,
  data = NULL,
  newdata = NULL,
  split = "gini",
  NodeRotateFun = "RotMatPPO",
  paramList = NULL,
  digits = NULL,
  main = NULL,
  ...
)
}
\arguments{
\item{formula}{Object of class \code{formula} with a response describing the model to fit. If this is a data frame, it is taken as the model frame. (see \code{\link{model.frame}})}

\item{data}{Training data of class \code{data.frame} in \code{\link{ODT}} used to calculate the OOB error.}

\item{newdata}{A data frame or matrix containing new data is used to calculate the test error. If it is missing, then it is replaced by \code{data}.}

\item{split}{The criterion used for splitting the variable. 'gini': gini impurity index (classification, default),
'entropy': information gain (classification) or 'mse': mean square error (regression).}

\item{NodeRotateFun}{Name of the function of class \code{character} that implements a linear combination of predictors in the split node.
including \itemize{
\item{"RotMatPPO": projection pursuit optimization model (\code{\link{PPO}}), see \code{\link{RotMatPPO}} (default, model="PPR").}
\item{"RotMatRF": single feature similar to Random Forest, see \code{\link{RotMatRF}}.}
\item{"RotMatRand": random rotation, see \code{\link{RotMatRand}}.}
\item{"RotMatMake": Users can define this function, for details see \code{\link{RotMatMake}}.}
}}

\item{paramList}{List of parameters used by the functions \code{NodeRotateFun}. If left unchanged, default values will be used, for details see \code{\link[ODRF]{defaults}}.}

\item{digits}{Integer indicating the number of decimal places (round) or significant digits (signif) to be used.}

\item{main}{main title}

\item{...}{Arguments to be passed to methods.}
}
\value{
OOB error and test error of \code{newdata}, misclassification rate (MR) for classification or mean square error (MSE) for regression.
}
\description{
Draw the error graph of class \code{ODT} at different depths.
}
\examples{
data(body_fat)
set.seed(221212)
train <- sample(1:252, 100)
train_data <- data.frame(body_fat[train, ])
test_data <- data.frame(body_fat[-train, ])
plot_ODT_depth(Density ~ ., train_data, test_data, split = "mse")

}
\seealso{
\code{\link{ODT}} \code{\link{plot.ODT}}
}
\keyword{plot}
\keyword{tree}
