% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spcrl.R
\name{spcrl}
\alias{spcrl}
\title{The stochastic principal  component  regression with varying learning-rate can handle online data sets.}
\usage{
spcrl(data, m, eta, alpha)
}
\arguments{
\item{data}{is a online data set}

\item{m}{is the number of principal component}

\item{eta}{is the proportion of online data to total data}

\item{alpha}{is the step size}
}
\value{
T2,T2k,V,Vhat,lambdahat,time
}
\description{
The stochastic principal  component  regression with varying learning-rate can handle online data sets.
}
\examples{

library(MASS)
n <- 2000
p <- 20
m <- 9
mu <- t(matrix(rep(runif(p, 0, 1000), p, n)))
mu0 <- as.matrix(runif(p, 0))  
sigma0 <- diag(runif(p, 1, 10)) 
ro <- as.matrix(c(runif(round(p/2), -1, -0.8), runif(p - round(p/2), 0.8, 1)))
R0 <- ro \%*\% t(ro)
diag(R0) <- 1
Sigma0 <- sigma0 \%*\% R0 \%*\% sigma0 
x <- mvrnorm(n, mu0, Sigma0)
colnames(x) <- paste0("x", 1:p)
e <- rnorm(n, 0, 1)
B <- sample(1:3, (p + 1), replace = TRUE)
en <- matrix(rep(1, n), ncol = 1)
y <- cbind(en, x) \%*\% B + e
colnames(y) <- "y"
data <- data.frame(cbind(y, x))
spcrl(data = data, m = m, eta = 0.8, alpha = 0.5)

}
