% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_multireader_data.R
\name{join_multireader_data}
\alias{join_multireader_data}
\title{Combine data from multiple antenna readers}
\usage{
join_multireader_data(x, verbose = FALSE)
}
\arguments{
\item{x}{A list object containing data frames compiled using \code{\link{import_ORFID}}.}

\item{verbose}{If \emph{TRUE}, a description of the compiled data is printed to the console.}
}
\value{
Returns a tibble object of distinct detections from multiple antenna readers.
}
\description{
Function to combine data from unique readers into an array, using reader data compiled using \code{\link{import_ORFID}}.
}
\details{
As in \code{\link{bind_rows}}, the output of \code{\link{join_multireader_data}} will contain a column if that column appears in any of the data inputs. The function creates a unique factor variable, \emph{LOC} (location), which is a combination of \emph{SCD} (site code) and \emph{ANT} (antenna).
}
\examples{

# Create a list containing compiled reader data:
readers <- list(reader_1, reader_2)

# Join data into a multi-reader array:
PIT_data <- join_multireader_data(readers)

}
\seealso{
\code{\link{import_ORFID}} for importing data files from Oregon RFID ORMR and ORSR antenna readers.
}
\author{
Hugo Marques <biohmarques@gmail.com>
}
