% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{ISMorrillK}
\alias{ISMorrillK}
\title{A function to compute K-th order Morrill's segregation index}
\usage{
ISMorrillK(x, ck = NULL, queen = FALSE, spatobj = NULL, folder = NULL, 
shape = NULL, K = 2, f = 'exp', beta = 1, prec = NULL)
}
\arguments{
\item{x}{- an object of class matrix (or which can be coerced to that class), 
where each column represents the distribution of a group within 
spatial units. The number of columns should be greaterTR than 1 (at least 2 
groups are required). You should not include a column with total 
population, because this will be interpreted as a group.}

\item{ck}{- a list containing contiguity matrices coresponding to each order 
(from 1 to K)}

\item{queen}{- logical parameter defining criteria used for contiguity 
matrix computation, TRUE for queen, FALSE (by default) for rook}

\item{spatobj}{- a spatial object (SpatialPolygonsDataFrame) with 
geographic information}

\item{folder}{- a character vector with the folder (directory) 
name indicating where the shapefile is located on the driveis located.}

\item{shape}{- a character vector with the name of the shapefile 
(without the .shp extension).}

\item{K}{- the order of the contiguity matrix}

\item{f}{- the distance function, f = 'exp' (by default) for negative 
exponential function and f = 'rec' for reciprocal function}

\item{beta}{- distance decay parameter}

\item{prec}{- precision parameter. If not NULL, the function stop computing
the spatial interaction when the impact on the indice is bellow 10 ^ (-prec)}
}
\value{
a matrix with Generalized Morrill's dissimilarity index values
}
\description{
This function computes an adaptation of Morrill's segregation 
index which takes into account the interactions between spatial units 
defined by K-th ordered contiguity matrix. The index can be used in two   
ways: to provide a contiguity units defined by K order contiguity matrix. The 
function can be used in two matrix or a external geographic information source 
(spatial object or shape file).
}
\examples{
x <- segdata@data[ ,1:2]
foldername <- system.file('extdata', package = 'OasisR')
shapename <- 'segdata'

ISMorrillK(x, spatobj = segdata, queen = FALSE, K = 3)

ISMorrillK(x, folder = foldername, shape = shapename, K = 4, f = 'rec') 

}
\references{
Morrill B. (1991) \emph{On the measure of geographic 
segregation}. Geography research forum, 11, pp. 25-36.
}
\seealso{
One-group evenness indices: 
\code{\link{ISDuncan}}, \code{\link{Gini}}, \code{\link{Gorard}}, 
\code{\link{HTheil}}, \code{\link{Atkinson}}, '\code{\link{ISWong}},
\code{\link{ISMorrill}}

Between groups dissimilarity indices: 
\code{\link{DIDuncan}}, \code{\link{Gini2}}, 
\code{\link{DIMorrill}}, \code{\link{DIMorrillK}}, \code{\link{DIWong}}
}
