% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotStudy}
\alias{plotStudy}
\title{Plot a feature using a custom plotting function}
\usage{
plotStudy(study, modelID, featureID, plotID, testID = NULL, libraries = NULL)
}
\arguments{
\item{study}{An OmicNavigator study. Either an object of class \code{onStudy},
or the name of an installed study package.}

\item{modelID}{Filter by modelID}

\item{featureID}{Filter by featureID}

\item{plotID}{Filter by plotID}

\item{testID}{Filter by testID}

\item{libraries}{The directories to search for installed study packages. If
left as \code{NULL} (the default), then
\code{\link[utils]{installed.packages}} will use the result of
\code{\link{.libPaths}}.}
}
\value{
This function is called for the side effect of creating a plot. It
  invisibly returns the result from the custom plotting function specified by
  \code{plotID}. Previously it invisibly returned the study object. It's
  unlikely you relied on this behavior. For a ggplot2 plot, the return value
  will be the plotting object with class \code{"ggplot"}.
}
\description{
Plot a feature using a custom plotting function
}
\details{
The arguments \code{study}, \code{modelID}, \code{featureID}, and
\code{testID} are passed to the function \code{\link{getPlottingData}}, and
the nested list returned by this function is passed as the first argument to
your custom plotting function.
}
\seealso{
\code{\link{addPlots}}, \code{\link{getPlottingData}}
}
