% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OmicsPLS.R
\name{loadings}
\alias{loadings}
\alias{loadings.o2m}
\title{Extract the loadings from an O2PLS fit}
\usage{
loadings(x, ...)

\method{loadings}{o2m}(x, loading_name = c("Xjoint", "Yjoint", "Xorth",
  "Yorth"), subset = 0, sorted = FALSE, ...)
}
\arguments{
\item{x}{Object of class \code{o2m}}

\item{...}{For consistency}

\item{loading_name}{character string. One of the following: 'Xjoint', 'Yjoint', 'Xorth' or 'Yorth'.}

\item{subset}{subset of loading vectors to be extracted.}

\item{sorted}{Logical. Should the rows of the loadings be sorted according to the 
absolute magnitute of the first column?}
}
\value{
Loading matrix
}
\description{
This function extracts loading parameters from an O2PLS fit
}
\examples{
loadings(o2m(scale(-2:2),scale(-2:2*4),1,0,0))

}
\seealso{
\code{\link{scores.o2m}}
}
