% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseConceptSetCounts.R
\name{summariseConceptSetCounts}
\alias{summariseConceptSetCounts}
\title{Summarise concept counts in patient-level data. Only concepts recorded during observation period are counted.}
\usage{
summariseConceptSetCounts(
  cdm,
  conceptSet,
  countBy = c("record", "person"),
  concept = TRUE,
  interval = "overall",
  sex = FALSE,
  ageGroup = NULL,
  dateRange = NULL
)
}
\arguments{
\item{cdm}{A cdm object}

\item{conceptSet}{List of concept IDs to summarise.}

\item{countBy}{Either "record" for record-level counts or "person" for
person-level counts}

\item{concept}{TRUE or FALSE. If TRUE code use will be summarised by concept.}

\item{interval}{Time interval to stratify by. It can either be "years", "quarters", "months" or "overall".}

\item{sex}{TRUE or FALSE. If TRUE code use will be summarised by sex.}

\item{ageGroup}{A list of ageGroup vectors of length two. Code use will be
thus summarised by age groups.}

\item{dateRange}{A list containing the minimum and the maximum dates
defining the time range within which the analysis is performed.}
}
\value{
A summarised_result object with results overall and, if specified, by
strata.
}
\description{
Summarise concept counts in patient-level data. Only concepts recorded during observation period are counted.
}
\examples{
\donttest{
library(OmopSketch)

cdm <- mockOmopSketch()

cs <- list(sumatriptan = c(35604883, 35604879, 35604880, 35604884))

results <- summariseConceptSetCounts(cdm, conceptSet = cs)

results

PatientProfiles::mockDisconnect(cdm)

}
}
