% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hist_combo3.R
\docType{data}
\name{hist_combo3}
\alias{hist_combo3}
\title{Dataset: historical and concurrent data on a three-way combination}
\format{A data frame with 18 rows and 7 variables:
\describe{
  \item{group_id}{study}
  \item{DosesAdm1}{dose of Drug A}
  \item{DosesAdm2}{dose of Drug B}
  \item{DosesAdm3}{dose of Drug C}
  \item{Npat}{number of patients}
  \item{Ntox}{number of DLTs}
  \item{stratum}{stratum for \code{group_id}'s used for differential discounting}
}}
\usage{
hist_combo3
}
\description{
This dataset involves a hypothetical dose-escalation study of combination
therapy with three treatment components. From two previous studies
\code{HistAgent1} and \code{HistAgent2}, historical data is available on each
of the treatments as single-agents, as well as two of the two-way
combinations. However, due to a difference in treatment schedule between the
\code{Combo} study and the historical studies, a stratification (through \code{stratum})
is made between the groups to allow differential discounting of the
alternate-schedule data.
}
\examples{
## Setting up dummy sampling for fast execution of example
## Please use 4 chains and 100x more warmup & iter in practice
.user_mc_options <- options(OncoBayes2.MC.warmup=10, OncoBayes2.MC.iter=20, OncoBayes2.MC.chains=1)

## example combo3

library(RBesT)
library(abind)

dref <- c(500, 500, 1000)
num_comp <- 3
num_inter <- choose(3,2) + 1
num_strata <- nlevels(hist_combo3$stratum)
num_groups <- nlevels(hist_combo3$group_id)

blrmfit <- blrm_exnex(cbind(Ntox, Npat-Ntox) ~
                          1 + I(log(DosesAdm1/dref[1])) |
                          1 + I(log(DosesAdm2/dref[2])) |
                          1 + I(log(DosesAdm3/dref[3])) |
                          0
                      + I(DosesAdm1/dref[1] * DosesAdm2/dref[2])
                      + I(DosesAdm1/dref[1] * DosesAdm3/dref[3])
                      + I(DosesAdm2/dref[2] * DosesAdm3/dref[3])
                      + I(DosesAdm1/dref[1] * DosesAdm2/dref[2] * DosesAdm3/dref[3]) |
                      stratum/group_id,
                      data=hist_combo3,
                      prior_EX_mu_mean_comp=matrix(c(logit(1/3), 0), nrow=num_comp, ncol=2, TRUE),
                      prior_EX_mu_sd_comp=matrix(c(2, 1), nrow=num_comp, ncol=2, TRUE),
          prior_EX_tau_mean_comp=abind(matrix(log(  c(0.25, 0.125)), nrow=num_comp, ncol=2, TRUE),
                                       matrix(log(2*c(0.25, 0.125)), nrow=num_comp, ncol=2, TRUE),
                                       along=0),
                      prior_EX_tau_sd_comp=abind(matrix(log(4)/1.96, nrow=num_comp, ncol=2, TRUE),
                                                 matrix(log(4)/1.96, nrow=num_comp, ncol=2, TRUE),
                                                 along=0),
                      prior_EX_mu_mean_inter=rep(0, num_inter),
                      prior_EX_mu_sd_inter=rep(sqrt(2)/2, num_inter),
                      prior_EX_tau_mean_inter=matrix(log(0.25)  , nrow=num_strata, ncol=num_inter),
                      prior_EX_tau_sd_inter=matrix(log(2)/1.96, nrow=num_strata, ncol=num_inter),
                      prior_EX_prob_comp=matrix(0.9, nrow=num_groups, ncol=num_comp),
                      prior_EX_prob_inter=matrix(0.9, nrow=num_groups, ncol=num_inter),
                      ## by default EXNEX is on for components and off for all interactions
                      prior_tau_dist=1,
                      prior_PD=FALSE
                      )
## Recover user set sampling defaults
options(.user_mc_options)

}
\keyword{datasets}
