% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{setSub1Params}
\alias{setSub1Params}
\title{Sets the parameters for a given "sub1"-object.}
\usage{
setSub1Params(sub1, alpha = 0.1, beta = 0.1, pc0 = 0.6, pt0 = 0.7,
  pc1 = 0.8, pt1 = 0.9)
}
\arguments{
\item{sub1}{a "sub1"-object which is generated by the function \code{\link{setupSub1Design}}.}

\item{alpha}{the maximal type I error rate.}

\item{beta}{the maximal type II error rate.}

\item{pc0}{the response probability for the subset endpoint under the null hypothesis.}

\item{pt0}{the response probability for the superset endpoint under the null hypothesis.}

\item{pc1}{the response probability for the subset endpoint under the alternative hypothesis.}

\item{pt1}{the response probability for the superset endpoint under the alternative hypothesis.}
}
\description{
Sets the parameters for a given "sub1"-object.
}
\examples{
#Create "sub1"-object.
sub1 <- setupSub1Design()
#Change parameters.
setSub1Params(sub1, beta = 0.2, pc0 = 0.5, pt0 = 0.6)
#Calculate designs for the given "sub1"-object.
designs <- getSolutionsSub1(sub1)$Solutions
designs
}
\seealso{
\code{\link{setupSub1Design}}
}
