% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MxCompute.R
\name{mxComputeLoadData}
\alias{mxComputeLoadData}
\alias{MxComputeLoadData-class}
\title{Load columns into an MxData object}
\usage{
mxComputeLoadData(dest, column, method = "CSV", ..., path,
  originalDataIsIndexOne = FALSE, byrow = TRUE, row.names = FALSE,
  col.names = FALSE, verbose = 0L, cacheSize = 100L)
}
\arguments{
\item{dest}{the name of the model where the columns will be loaded}

\item{column}{a character vector. The column names to replace.}

\item{method}{name of the conduit used to load the columns.}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{path}{when method='CSV', the path to the file containing the data}

\item{originalDataIsIndexOne}{logical. Whether to use the initial data for index 1}

\item{byrow}{logical. Whether the data columns are stored in rows (TRUE)
or columns (FALSE) on disk.}

\item{row.names}{logical. Whether row names are present.}

\item{col.names}{logical. Whether column names are present.}

\item{verbose}{integer. Level of diagnostic output.}

\item{cacheSize}{integer. How many columns to cacheSize per
scan through the data.}
}
\description{
The purpose of this compute step is to help quickly perform many
similar analyses. For example, if we are given a sample of people
with a few million SNPs (single-nucleotide polymorphism) per
person then we could fit a separate model for each SNP by iterating
over the SNP data.
}
\details{
The column names given in the \code{column} parameter must already
exist in the model's MxData object. The data is assumed to be
a placeholder and is not used unless
\code{originalDataIsIndexOne} is set to TRUE.

When \code{byrow} is FALSE, it is necessary to read through the
whole file on disk to load a single column. To amortize the cost
of reading through the file, \code{cacheSize} are loaded each
pass through the file.
}
\seealso{
\link{mxComputeLoadMatrix}, \link{mxComputeCheckpoint}
}
